/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.optionitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListOptionItem
implements Select.OptionItemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ListOptionItem.class);
    private final String code;
    private final Reference relRef1;
    private final Reference relRef2;
    private final DataResource dataResource;
    private final boolean localized;

    public ListOptionItem(String code, Reference relRef1, Reference relRef2, DataResource dataResource, boolean localized) {
        this.code = code;
        this.relRef1 = relRef1;
        this.relRef2 = relRef2;
        this.dataResource = dataResource;
        this.localized = localized;
    }

    @Override
    public OptionItemsDTO getOptionItems(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        Object ref1 = null;
        Object ref2 = null;
        try {
            Map<Object, OptionItemDTO> map;
            ModelItemDTO miDTO;
            if (this.relRef1 != null && (miDTO = dataModel.get(EngineUtil.mergeModelKey(this.relRef1.getName(), dataModelKey))) != null) {
                ref1 = miDTO.getValue();
            }
            if (this.relRef2 != null && (miDTO = dataModel.get(EngineUtil.mergeModelKey(this.relRef2.getName(), dataModelKey))) != null) {
                ref2 = miDTO.getValue();
            }
            if (this.dataResource != null && (map = this.dataResource.get(this.code, ref1, ref2)) != null) {
                if (this.localized) {
                    Map<Object, OptionItemDTO> optionsMap = map;
                    return OptionItemsDTO.createLocalized(optionsMap);
                }
                Map<Object, OptionItemDTO> optionsMap = map;
                return OptionItemsDTO.createPlain(optionsMap);
            }
            return OptionItemsDTO.createEmpty(this.localized);
        }
        catch (RuntimeException rte) {
            LOG.error("Error on item code: " + this.code + " with params: " + String.valueOf(ref1) + ", " + String.valueOf(ref2));
            throw rte;
        }
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.relRef1 != null) {
            this.relRef1.registerListenerOnReference(logicModel, logicModelItem, true);
        }
        if (this.relRef2 != null) {
            this.relRef2.registerListenerOnReference(logicModel, logicModelItem, true);
        }
    }

    @Override
    public boolean hasLocalizedOptions() {
        return this.localized;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            DataResource dataResource = null;
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof DataResource) {
                        dataResource = (DataResource)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Reference ref1 = null;
            Reference ref2 = null;
            if (element.getAttribute("ref1") != null) {
                ref1 = new Reference(element.getAttributeValue("ref1"), true);
            }
            if (element.getAttribute("absRef1") != null) {
                ref1 = new Reference(element.getAttributeValue("absRef1"), false);
            }
            if (element.getAttribute("ref2") != null) {
                ref2 = new Reference(element.getAttributeValue("ref2"), true);
            }
            if (element.getAttribute("absRef2") != null) {
                ref2 = new Reference(element.getAttributeValue("absRef2"), false);
            }
            boolean localized = Boolean.valueOf(element.getAttributeValue("localized"));
            ListOptionItem result = new ListOptionItem(element.getAttributeValue("list"), ref1, ref2, dataResource, localized);
            return new ClassObjectPair(ListOptionItem.class, (Object)result);
        }
    }
}

