/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.modelitems.Value;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ValueWithLimitedValidatorModifications
extends Value {
    private Reference[] modificationValidationEventSources = null;

    public ValueWithLimitedValidatorModifications(String name, String persistenceKeyTemplate, String importPrevious, Object[] validators, Reference[] modificationValidationEventSources, boolean hasInitialGreenState) {
        super(name, persistenceKeyTemplate, null, false, importPrevious, hasInitialGreenState, false, false);
        for (Object o : validators) {
            if (!(o instanceof Validator)) continue;
            this.addValidator((Validator)o);
        }
        this.modificationValidationEventSources = (Reference[])modificationValidationEventSources.clone();
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        if (this.modificationValidationEventSources != null) {
            for (Reference modificationValidationEventSource : this.modificationValidationEventSources) {
                modificationValidationEventSource.initializeReference(logicModel, this, false);
            }
        }
        super.additionalInitializeReferences(logicModel);
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        super.setValueWithOptionalValidation(dataModel, dataModelKey, modelItemDTO, changedEventsOnlyOutsideOfThisTable, true, false);
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        boolean modificationEventSource = false;
        if (this.modificationValidationEventSources != null) {
            for (int i = 0; i < this.modificationValidationEventSources.length && !modificationEventSource; ++i) {
                String itemName = this.modificationValidationEventSources[i].getName();
                if (!EngineUtil.removeTableIndices(dataModelKey).equals(itemName)) continue;
                modificationEventSource = true;
            }
        }
        super.dataChangedWithConditionalActiveValidation(dataModel, dataModelKey, changedEventsOnlyOutsideOfThisTable, modificationEventSource);
    }
}

