/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Module
extends LogicModelItem {
    private final String title;
    private final boolean importantState;
    private final boolean transparentIfNotReleasable;
    private final boolean transparentIfNotReleased;
    private final boolean transparentIfReleased;
    private final boolean disabledIfCd;
    private final boolean disabledIfOnline;
    private final boolean listenToStateEvents;
    private final boolean transparentIfReceipted;
    private final boolean noNavigation;

    public Module(String name, String title, List<LogicModelItem> children, String persistenceKeyTemplate, boolean importantState, boolean transparentIfNotReleasable, boolean transparentIfNotReleased, boolean transparentIfReleased, boolean disabledIfCd, boolean disabledIfOnline, boolean listenToStateEvents, boolean readonlyIfTransparent, boolean barcode, boolean transparentIfReceipted, boolean noNavigation) {
        super(name, children, persistenceKeyTemplate, false, "false", readonlyIfTransparent, barcode, new SimpleValuePersistenceHint());
        this.title = title;
        this.importantState = importantState;
        this.transparentIfNotReleasable = transparentIfNotReleasable;
        this.transparentIfNotReleased = transparentIfNotReleased;
        this.transparentIfReleased = transparentIfReleased;
        this.disabledIfCd = disabledIfCd;
        this.disabledIfOnline = disabledIfOnline;
        this.listenToStateEvents = listenToStateEvents;
        this.transparentIfReceipted = transparentIfReceipted;
        this.noNavigation = noNavigation;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isImportantState() {
        return this.importantState;
    }

    public boolean isTransparentIfNotReleasable() {
        return this.transparentIfNotReleasable;
    }

    public boolean isTransparentIfNotReleased() {
        return this.transparentIfNotReleased;
    }

    public boolean isTransparentIfReleased() {
        return this.transparentIfReleased;
    }

    public boolean isDisabledIfCd() {
        return this.disabledIfCd;
    }

    public boolean isDisabledIfOnline() {
        return this.disabledIfOnline;
    }

    public boolean isTransparentIfReceipted() {
        return this.transparentIfReceipted;
    }

    public boolean isNoNavigation() {
        return this.noNavigation;
    }

    @Override
    public void stateChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        if (this.listenToStateEvents) {
            this.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<LogicModelItem> childItems = !elements.isEmpty() ? new ArrayList<LogicModelItem>() : null;
            ArrayList<Validator> validators = new ArrayList<Validator>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser elementParser = factory.getParser(subElementName);
                    ClassObjectPair cop = elementParser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LogicModelItem) {
                        childItems.add((LogicModelItem)ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            boolean importantState = true;
            if (element.getAttribute("is-state-important") != null) {
                importantState = Boolean.getBoolean(element.getAttributeValue("is-state-important"));
            }
            Module result = new Module(element.getAttributeValue("name"), element.getAttributeValue("title") == null ? element.getAttributeValue("name") : element.getAttributeValue("title"), childItems, element.getAttributeValue("pKey"), importantState, Boolean.valueOf(element.getAttributeValue("transparent-if-not-releasable")), Boolean.valueOf(element.getAttributeValue("transparent-if-not-released")), Boolean.valueOf(element.getAttributeValue("transparent-if-released")), Boolean.valueOf(element.getAttributeValue("disabled-if-cd")), Boolean.valueOf(element.getAttributeValue("disabled-if-online")), Boolean.valueOf(element.getAttributeValue("listen-to-state-events")), Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")), Boolean.parseBoolean(element.getAttributeValue("barcode")), Boolean.parseBoolean(element.getAttributeValue("transparent-if-receipted")), Boolean.parseBoolean(element.getAttributeValue("no-navigation")));
            for (Object e : validators) {
                result.addValidator((Validator)e);
            }
            return new ClassObjectPair(Module.class, (Object)result);
        }
    }
}

