/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListRowContent;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertListIteratorItem
extends ExpertListRowContent {
    private final String tableKey;
    private final String stateKey;
    private LogicModelItem tableItem;
    private LogicModelItem stateItem;
    private final List<ExpertListRowContent> children;

    public ExpertListIteratorItem(String tableKey, String stateKey, List<ExpertListRowContent> rows) {
        super(null, 8, true);
        this.tableKey = tableKey;
        this.stateKey = stateKey;
        this.children = rows;
    }

    public List<ExpertListRowContent> getChildren() {
        return this.children;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.stateKey != null) {
            this.stateItem = logicModelItems.get(this.stateKey);
            if (this.stateItem == null) {
                throw new InvalidModelException("invalid state-reference in Row (key=" + this.stateKey + ")");
            }
        }
        if (this.tableKey != null) {
            this.tableItem = logicModelItems.get(this.tableKey);
            if (this.tableItem == null) {
                throw new InvalidModelException("invalid table-reference in Row (key=" + this.tableKey + ")");
            }
        } else {
            throw new InvalidModelException("missing table-reference in Row");
        }
    }

    public List<ExpertDisplayInfoDTO.ListDTO.RowDTO> getRowDTOs(ExpertDisplayModel.RequestContext requestContext) {
        String dmk;
        if (this.stateItem != null) {
            dmk = ExpertDisplayUtil.getModelItemKey(this.stateItem, requestContext.getFormAccessKey());
            ModelItemDTO miDTO = requestContext.getDataModel().get(dmk);
            if (miDTO == null) {
                return null;
            }
            if (miDTO.getState() == 12) {
                return null;
            }
        }
        dmk = ExpertDisplayUtil.getModelItemKey(this.tableItem, requestContext.getFormAccessKey());
        ModelItemDTO tableDTO = requestContext.getDataModel().get(dmk);
        if (tableDTO == null || !(tableDTO.getValue() instanceof Set)) {
            return null;
        }
        ArrayList<ExpertDisplayInfoDTO.ListDTO.RowDTO> result = new ArrayList<ExpertDisplayInfoDTO.ListDTO.RowDTO>();
        for (Object value : (Set)tableDTO.getValue()) {
            StringBuilder newFAK = new StringBuilder(requestContext.getFormAccessKey());
            if (!newFAK.toString().endsWith("#")) {
                newFAK.append(".");
            }
            newFAK.append(value.toString());
            ExpertDisplayModel.RequestContext rc = new ExpertDisplayModel.RequestContext(requestContext.getDataModel(), newFAK.toString(), requestContext.getDefaultFont(), requestContext.getDefaultTableFont(), requestContext.getDefaultTableHeaderFont(), requestContext.getDefaultTableTitleFont(), requestContext.getDefaultTableTitlePattern(), requestContext.getLogicModelItems());
            for (ExpertListRowContent child : this.children) {
                ExpertListRowContent item;
                List<? extends ExpertDisplayInfoDTO.ListDTO.RowDTO> rowDTOs;
                if (!(child instanceof ExpertListRowContent) || (rowDTOs = (item = child).getRowDTOs(rc)) == null) continue;
                result.addAll(rowDTOs);
            }
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<ExpertListRowContent> children = new ArrayList<ExpertListRowContent>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertListRowContent) {
                        children.add((ExpertListRowContent)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            ExpertListIteratorItem elrii = new ExpertListIteratorItem(element.getAttributeValue("table"), element.getAttributeValue("state"), children);
            return new ClassObjectPair(ExpertListIteratorItem.class, (Object)elrii);
        }
    }
}

