/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.modelitems.addons.CommandItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.presentation.common.util.RenderBuilder;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertButtonItem
extends ExpertFormDisplayModelItem {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final ColorDTO bgColor;
    private final String commandItemName;
    private final String valueItemName;
    private final String stateItemName;
    private final String key;
    private final String icon;
    private final String uri;
    private final String target;
    private CommandItem commandItem;
    private LogicModelItem valueItem;
    private LogicModelItem stateItem;
    private final Render reRender;

    public ExpertButtonItem(String key, int x, int y, int width, int height, ColorDTO bgColor, Set<String> languages, String commandDmk, String valueDmk, String stateDmk, String icon, String uri, String target, Render reRender) {
        super(languages, 0, true);
        this.key = key;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bgColor = bgColor;
        this.commandItemName = commandDmk;
        this.valueItemName = valueDmk;
        this.uri = uri;
        this.icon = icon;
        this.stateItemName = stateDmk;
        this.target = target;
        this.reRender = reRender;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.commandItemName != null) {
            this.commandItem = (CommandItem)logicModelItems.get(this.commandItemName);
            if (this.commandItem == null) {
                throw new InvalidModelException("invalid commandDmk in button: " + this.commandItemName + " in " + this.getClass().getName());
            }
        }
        if (this.valueItemName != null) {
            this.valueItem = logicModelItems.get(this.valueItemName);
            if (this.valueItem == null) {
                throw new InvalidModelException("invalid valueDmk in button: " + this.valueItemName + " in " + this.getClass().getName());
            }
        }
        if (this.stateItemName != null) {
            this.stateItem = logicModelItems.get(this.stateItemName);
            if (this.stateItem == null) {
                throw new InvalidModelException("invalid stateDmk in button: " + this.stateItemName + " in " + this.getClass().getName());
            }
        }
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        ModelItemDTO miDTO;
        String cmdDmk = null;
        if (this.commandItem != null) {
            cmdDmk = ExpertDisplayUtil.getModelItemKey(this.commandItem, requestContext.getFormAccessKey());
        }
        String valDmk = null;
        if (this.valueItem != null) {
            valDmk = ExpertDisplayUtil.getModelItemKey(this.valueItem, requestContext.getFormAccessKey());
        }
        String stateDmk = null;
        if (this.stateItem != null) {
            stateDmk = ExpertDisplayUtil.getModelItemKey(this.stateItem, requestContext.getFormAccessKey());
        }
        int state = 1;
        ArrayList<MessageItemDTO> messages = null;
        if (this.stateItem != null && (miDTO = requestContext.getDataModel().getWithoutTouch(stateDmk)) != null) {
            state = miDTO.getState();
            if (miDTO.getMessages() != null && !miDTO.getMessages().isEmpty()) {
                messages = new ArrayList<MessageItemDTO>();
                messages.addAll(miDTO.getMessages());
            }
        }
        if (this.stateItem != null) {
            for (LogicModelItem lmi = this.stateItem.getParent(); lmi != null; lmi = lmi.getParent()) {
                if (!lmi.isReadonlyIfTransparent()) continue;
                String s = EngineUtil.mergeModelKey(lmi.getName(), stateDmk);
                ModelItemDTO mi = requestContext.getDataModel().get(s);
                if (mi == null || mi.getState() != 11) continue;
                return null;
            }
        }
        return new ExpertDisplayInfoDTO.ButtonDTO(this.x, this.y, this.width, this.height, this.bgColor, cmdDmk, valDmk, this.key, this.icon, this.uri, state, requestContext.getDataModel().get(cmdDmk), this.getUniqueItemIdentifier(), messages, this.target, this.reRender);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Render reRender = new Render();
            if (element.getAttribute("reRender") != null) {
                reRender = RenderBuilder.create(element.getAttributeValue("reRender")).build();
            }
            ExpertButtonItem eli = new ExpertButtonItem(element.getAttributeValue("key"), ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), element.getAttributeValue("commandDmk"), element.getAttributeValue("valueDmk"), element.getAttributeValue("stateDmk"), element.getAttributeValue("icon"), element.getAttributeValue("URI"), element.getAttributeValue("target"), reRender);
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)eli);
        }
    }
}

