/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Substring
implements CalcItem {
    private final int start;
    private final int end;

    public Substring(int start) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("invalid start index: " + start);
        }
        this.start = start;
        this.end = -1;
    }

    public Substring(int start, int end) {
        if (start < 0 || start > end) {
            throw new IndexOutOfBoundsException("invalid start/end index: " + start + "/" + end);
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 1) {
            throw new IllegalArgumentException("Substring needs 1 element on stack");
        }
        Object obj = stack.pop();
        if (obj == null) {
            stack.push(null);
            return;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (this.end != -1) {
                assert (this.start <= this.end);
                if (this.end <= s.length()) {
                    stack.push(s.substring(this.start, this.end));
                }
            } else if (this.start <= s.length()) {
                stack.push(s.substring(this.start));
            }
        } else {
            throw new IllegalArgumentException("argument of Substring need to be of type String");
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Substring result;
            String startStr = element.getAttributeValue("start");
            String endStr = element.getAttributeValue("end");
            if (startStr == null) {
                throw new ElementParserException("'start' attribute must be specified");
            }
            try {
                int start = Integer.parseInt(startStr);
                if (endStr != null) {
                    int end = Integer.parseInt(endStr);
                    result = new Substring(start, end);
                } else {
                    result = new Substring(start);
                }
            }
            catch (NumberFormatException e) {
                throw new ElementParserException("start/end attributes must be valid integers", (Throwable)e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ElementParserException("invalid start/end position", (Throwable)e);
            }
            return new ClassObjectPair(Substring.class, (Object)result);
        }
    }
}

