/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RelRef
extends Reference
implements CalcItem {
    public RelRef(String name) {
        super(name, true);
    }

    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        ModelItemDTO value = dataModel.get(EngineUtil.mergeModelKey(this.getName(), dataModelKey));
        if (value != null) {
            stack.push(value.getValue());
        } else {
            stack.push(null);
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String name = element.getAttributeValue("name");
            if (name == null) {
                throw new ElementParserException("Attribute 'name' is mandatory for rel-ref item.");
            }
            return new ClassObjectPair(Reference.class, (Object)new RelRef(name));
        }
    }
}

