/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Power
implements CalcItem {
    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Power needs 2 elements on stack");
        }
        Object value1 = stack.pop();
        Object value2 = stack.pop();
        if (value1 == null && value2 == null) {
            stack.push(null);
            return;
        }
        if (value1 == null || value1.toString().isEmpty()) {
            value1 = 0L;
        }
        if (value2 == null || value2.toString().isEmpty()) {
            value2 = 0L;
        }
        if (value1 instanceof Long && value2 instanceof Long) {
            double l = Math.pow(((Long)value2).longValue(), ((Long)value1).longValue());
            stack.push(Math.round(l));
        } else if (value1 instanceof Number && value2 instanceof Number) {
            double d = Math.pow(((Number)value2).doubleValue(), ((Number)value1).doubleValue());
            stack.push(d);
        } else {
            throw new IllegalArgumentException("Both arguments of Power must be of type number");
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Power result = new Power();
            return new ClassObjectPair(Power.class, (Object)result);
        }
    }
}

