/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Opposite
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Opposite needs 1 element on stack");
        }
        Object value1 = stack.pop();
        if (value1 == null || value1.toString().isEmpty()) {
            stack.push(null);
            return;
        }
        if (value1 instanceof Long) {
            long l = 0L - (Long)value1;
            stack.push(l);
        } else if (value1 instanceof Number) {
            double d = 0.0 - ((Number)value1).doubleValue();
            stack.push(d);
        } else {
            throw new IllegalArgumentException("argument of Opposite needs to be of type Number");
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Opposite result = new Opposite();
            return new ClassObjectPair(Opposite.class, (Object)result);
        }
    }
}

