/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.calcitems.AbstractCompare;
import ch.dvbern.tax.common.engine.util.CompareUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import java.math.BigDecimal;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GenericCompare
extends AbstractCompare {
    private final CompareUtil.Operator operator;
    private final Object rhs;

    public GenericCompare(CompareUtil.Operator operator, Object rhs, boolean nullAsZero) {
        super(nullAsZero);
        if (operator == null) {
            throw new NullPointerException("Operator cannot be null");
        }
        this.operator = operator;
        this.rhs = rhs;
    }

    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        Object rhs = this.rhs != null ? this.rhs : stack.pop();
        Object lhs = stack.pop();
        stack.push(this.compare(this.operator, lhs, rhs));
    }

    public static class XMLFactory
    implements ElementParser {
        private final CompareUtil.Operator operator;
        private final String rhsName;
        private final boolean forceNullAsZero;

        public XMLFactory(CompareUtil.Operator operator) {
            this(operator, false);
        }

        public XMLFactory(CompareUtil.Operator operator, boolean forceNullAsZero) {
            if (operator == null) {
                throw new NullPointerException("Operator cannot be null");
            }
            this.operator = operator;
            this.forceNullAsZero = forceNullAsZero;
            this.rhsName = operator == CompareUtil.Operator.EQUAL || operator == CompareUtil.Operator.NOT_EQUAL ? "to" : "than";
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            BigDecimal rhs;
            boolean nullAsZero;
            String nullAsZeroStr = element.getAttribute("nullAsZero");
            if (nullAsZeroStr != null) {
                if (this.forceNullAsZero) {
                    throw new ElementParserException("Cannot specify nullAsZero attribute on item " + element.getName());
                }
                nullAsZero = Boolean.valueOf(nullAsZeroStr);
            } else {
                nullAsZero = this.forceNullAsZero;
            }
            String rhsStr = element.getAttribute(this.rhsName);
            if (rhsStr != null) {
                try {
                    rhs = new BigDecimal(rhsStr);
                }
                catch (NumberFormatException e) {
                    throw new ElementParserException("Attribute value \"" + this.rhsName + "\" must be a valid number.");
                }
            } else {
                rhs = null;
            }
            return new ClassObjectPair(GenericCompare.class, (Object)new GenericCompare(this.operator, rhs, nullAsZero));
        }
    }
}

