/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Abs
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Abs needs 1 element on stack");
        }
        Object value1 = stack.pop();
        if (value1 == null) {
            stack.push(null);
            return;
        }
        if (value1.toString().isEmpty()) {
            value1 = 0L;
        }
        if (value1 instanceof Long) {
            double l = Math.abs((Long)value1);
            stack.push(l);
        } else if (value1 instanceof Number) {
            double d = Math.abs(((Number)value1).doubleValue());
            stack.push(d);
        } else {
            stack.push(null);
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Abs result = new Abs();
            return new ClassObjectPair(Abs.class, (Object)result);
        }
    }
}

