/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LMKTreeNode;
import ch.dvbern.tax.common.engine.LMKTreeRoot;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Table;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LMKTableTree {
    private final @NonNull LMKTreeRoot root;

    public LMKTableTree(Map<String, LogicModelItem> logicModel) {
        LMKTreeRoot root = new LMKTreeRoot();
        for (Map.Entry<String, LogicModelItem> entry : logicModel.entrySet()) {
            this.insert(root, entry.getValue(), logicModel);
        }
        this.root = root;
    }

    public LMKTreeNode findTableNode(@NonNull LMK tableLMK) {
        return this.root.findTableNode(tableLMK);
    }

    private @NonNull LMKTreeRoot insert(@NonNull LMKTreeRoot root, @NonNull LogicModelItem lmi, @NonNull Map<String, LogicModelItem> logicModel) {
        Objects.requireNonNull(lmi);
        Optional<LMK> containingTableOpt = lmi.findContainingTable().map(LogicModelItem::getLMK);
        return containingTableOpt.map(containingTable -> this.putNodeIntoTable(root, lmi, logicModel, (LMK)containingTable)).orElseGet(() -> LMKTableTree.putNode(lmi, root));
    }

    private @NonNull LMKTreeRoot putNodeIntoTable(@NonNull LMKTreeRoot root, @NonNull LogicModelItem lmi, @NonNull Map<String, LogicModelItem> logicModel, @NonNull LMK containingTable) {
        LMKTreeRoot parentTableNode = this.insert(root, logicModel.get(containingTable.toExternalForm()), logicModel);
        if (parentTableNode != null) {
            return LMKTableTree.putNode(lmi, parentTableNode);
        }
        return LMKTableTree.putNode(lmi, root);
    }

    private static @NonNull LMKTreeRoot putNode(@NonNull LogicModelItem lmi, LMKTreeRoot parentTableNode) {
        if (lmi instanceof Table) {
            LMKTreeNode tableNode = parentTableNode.putChildTable(LMK.parse(lmi.getName()));
            return tableNode;
        }
        parentTableNode.addChildItem(LMK.fromLogicModelItem(lmi));
        return parentTableNode;
    }
}

