/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.NotYetImplementedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public class DMK
implements Serializable,
Comparable<DMK> {
    private static final long serialVersionUID = 3067414455458680892L;
    private static final String PART_SEPARATOR = ".";
    private static final String PART_SPLITTER = "\\.";
    private static final Pattern DMK_PART_PATTERN = Pattern.compile("^[_\\p{Alpha}][\\p{Alpha}0-9_]*$");
    private static final Pattern DMK_ROWNUM_PATTERN = Pattern.compile("^\\d+$");
    private static final Entry[] NO_ENTRIES = new Entry[0];
    private final @NonNull String externalForm;
    private final @NonNull Entry[] parts;
    public static final @NonNull DMK ROOT = DMK.parse("");
    public static final long MIN_ALLOWED_ROW_NUM = 0L;

    private DMK(@NonNull Entry[] parts) {
        this.externalForm = DMK.joinParts(parts);
        this.parts = parts;
    }

    public DMK(@NonNull String dmk) {
        Objects.requireNonNull(dmk);
        try {
            this.externalForm = dmk;
            this.parts = DMK.parseParts(dmk);
        }
        catch (RuntimeException rte) {
            throw new IllegalArgumentException("Not a valid DMK: >" + dmk + "<", rte);
        }
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable DMK parse(@Nullable String dmkString) {
        if (dmkString == null) {
            return null;
        }
        return new DMK(dmkString);
    }

    private static String joinParts(@NonNull Entry[] parts) {
        StringBuilder bld = new StringBuilder();
        for (Entry part : parts) {
            if (bld.length() > 0) {
                bld.append(PART_SEPARATOR);
            }
            bld.append(part.toExternalForm());
        }
        return bld.toString();
    }

    private static Entry[] parseParts(@NonNull String dmk) {
        if (dmk.isEmpty()) {
            return NO_ENTRIES;
        }
        if (dmk.endsWith(PART_SEPARATOR)) {
            throw new IllegalArgumentException("DMK ending in '.' is not allowed: " + dmk);
        }
        String[] partNames = dmk.split(PART_SPLITTER);
        if (partNames.length == 0) {
            throw new IllegalArgumentException("No parts in DMK???: " + dmk);
        }
        if (DMK_ROWNUM_PATTERN.matcher(partNames[0]).matches()) {
            throw new IllegalArgumentException("DMK must start with Text (not numbers!)" + dmk);
        }
        ArrayList<Entry> entries = new ArrayList<Entry>(partNames.length);
        for (String name : partNames) {
            if (DMK_PART_PATTERN.matcher(name).matches()) {
                entries.add(new Entry(name));
                continue;
            }
            if (DMK_ROWNUM_PATTERN.matcher(name).matches()) {
                if (((Entry)entries.get(entries.size() - 1)).isTableRow()) {
                    throw new IllegalArgumentException("DMK must not contain to numbers in a row: " + dmk);
                }
                int lastFieldPos = entries.size() - 1;
                Entry entry = (Entry)entries.get(lastFieldPos);
                if (entry.isTableRow()) {
                    throw new IllegalArgumentException("Two row numbers in a row for: " + dmk + "@" + name);
                }
                long rowNum = Long.parseLong(name);
                entries.set(lastFieldPos, new Entry(entry.getName(), rowNum));
                continue;
            }
            throw new IllegalArgumentException("DMK part does not match any pattern: " + dmk + "@" + name);
        }
        return entries.toArray(NO_ENTRIES);
    }

    public static DMK root() {
        return ROOT;
    }

    public @NonNull DMK append(@NonNull Entry entry) {
        Entry[] newParts = Arrays.copyOf(this.parts, this.parts.length + 1);
        newParts[newParts.length - 1] = entry;
        return new DMK(newParts);
    }

    public @NonNull DMK append(@NonNull String entryName) {
        return this.append(new Entry(entryName, null));
    }

    public @NonNull DMK toTableRow(long rowNum) {
        if (rowNum < 0L) {
            throw new IllegalArgumentException("rowNum not allowed: " + rowNum);
        }
        String lastPartName = this.parts[this.parts.length - 1].getName();
        return this.getParent().append(new Entry(lastPartName, rowNum));
    }

    public @NonNull DMK getParent() {
        if (this.isRoot()) {
            throw new IllegalArgumentException("A root DMK does not have a parent");
        }
        if (this.isToplevel()) {
            return ROOT;
        }
        return new DMK(Arrays.copyOf(this.parts, this.parts.length - 1));
    }

    public boolean isToplevel() {
        return this.parts.length == 1;
    }

    public boolean isFlat() {
        for (Entry part : this.parts) {
            if (!part.isTableRow()) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        return this.parts.length == 0;
    }

    public boolean isRowDMK() {
        return !this.isRoot() && this.parts[this.parts.length - 1].isTableRow();
    }

    public long getRowNum() {
        if (!this.isRowDMK()) {
            throw new IllegalArgumentException("This DMK is no table row: " + String.valueOf(this));
        }
        Entry part = this.parts[this.parts.length - 1];
        return Objects.requireNonNull(part.rowNum, "this entry is no row: " + part.name);
    }

    public @Nullable DMK findInnermostTableRowDMK() {
        for (int i = this.parts.length - 1; i >= 0; --i) {
            if (!this.parts[i].isTableRow()) continue;
            return new DMK(Arrays.copyOf(this.parts, i + 1));
        }
        return null;
    }

    public @Nullable DMK findOutermostTableRowDMK() {
        for (int i = 0; i < this.parts.length; ++i) {
            if (!this.parts[i].isTableRow()) continue;
            return new DMK(Arrays.copyOf(this.parts, i + 1));
        }
        return null;
    }

    public LMK toLMK() {
        if (this.isRoot()) {
            throw new NotYetImplementedException("Maybe introduce a root level LMK?");
        }
        StringBuilder bld = new StringBuilder();
        for (Entry part : this.parts) {
            if (bld.length() != 0) {
                bld.append(PART_SEPARATOR);
            }
            bld.append(part.getName());
        }
        return new LMK(bld.toString());
    }

    public @NonNull DMK findRowInTable(@NonNull DMK tableDMK) {
        if (!tableDMK.containsChild(this)) {
            throw new IllegalArgumentException("TableDMK " + String.valueOf(tableDMK) + " does not contain " + String.valueOf(this));
        }
        int tableRowPartsCount = tableDMK.parts.length;
        DMK tableRowDMK = new DMK(Arrays.copyOf(this.parts, tableRowPartsCount));
        return tableRowDMK;
    }

    @Deprecated
    public @NonNull DMK getRowDMKForTableDMK(@NonNull DMK tableDMK) {
        return this.findRowInTable(tableDMK);
    }

    public DMK merge(@NonNull LMK lmk) {
        int i;
        String[] lmkParts = lmk.getParts();
        int maxLen = Math.min(this.parts.length, lmkParts.length);
        Entry[] merged = new Entry[lmkParts.length];
        for (i = 0; i < maxLen; ++i) {
            merged[i] = new Entry(lmkParts[i], this.parts[i].rowNum);
        }
        for (i = maxLen; i < lmkParts.length; ++i) {
            merged[i] = new Entry(lmkParts[i]);
        }
        return new DMK(merged);
    }

    public @NonNull Optional<Set<DMK>> findRowDMKs(@NonNull Map<String, ModelItemDTO> dataModel) {
        Objects.requireNonNull(dataModel);
        Object tableValue = dataModel.getOrDefault(this.toExternalForm(), new ModelItemDTO(null)).getValue();
        if (tableValue == null) {
            return Optional.empty();
        }
        Set tableRowDMKs = (Set)tableValue;
        Set result = tableRowDMKs.stream().map(Long::parseLong).map(this::toTableRow).collect(Collectors.toSet());
        return Optional.of(result);
    }

    @Override
    public int compareTo(@NonNull DMK o) {
        int partsCount = Math.min(this.parts.length, o.parts.length);
        for (int i = 0; i < partsCount; ++i) {
            int cmp = this.parts[i].compareTo(o.parts[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(this.parts.length, o.parts.length);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DMK other = (DMK)o;
        return this.externalForm.equals(other.externalForm);
    }

    public int hashCode() {
        return this.externalForm.hashCode();
    }

    public @NonNull String toExternalForm() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.parts.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            Entry part = this.parts[i];
            sb.append(part.toExternalForm());
        }
        return sb.toString();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.externalForm).toString();
    }

    public boolean containsChild(@NonNull DMK otherDMK) {
        if (this.isRoot() && otherDMK.isRoot()) {
            return false;
        }
        if (otherDMK.parts.length < this.parts.length) {
            return false;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            Entry thisPart = this.parts[i];
            Entry otherPart = otherDMK.parts[i];
            if (i < this.parts.length - 1) {
                if (thisPart.equals(otherPart)) continue;
                return false;
            }
            if (!thisPart.isTableRow() && otherPart.isTableRow()) {
                return thisPart.getName().equals(otherPart.getName());
            }
            return thisPart.equals(otherPart) && otherDMK.parts.length > this.parts.length;
        }
        return true;
    }

    public @NonNull Optional<ModelItemDTO> modelItem(@NonNull Map<String, ModelItemDTO> dataModel) {
        return Optional.ofNullable(dataModel.get(this.toExternalForm()));
    }

    public @NonNull Optional<Object> modelValue(@NonNull Map<String, ModelItemDTO> dataModel) {
        return this.modelItem(dataModel).map(ModelItemDTO::getValue);
    }

    public static class Entry
    implements Serializable,
    Comparable<Entry> {
        private static final long serialVersionUID = 919149049680266787L;
        private final @NonNull String name;
        private final @Nullable Long rowNum;

        Entry(@NonNull String name) {
            this(name, null);
        }

        Entry(@NonNull String name, @Nullable Long rowNum) {
            Objects.requireNonNull(name);
            if (!DMK_PART_PATTERN.matcher(name).matches()) {
                throw new IllegalArgumentException("Not a valid part name: >" + name + "<");
            }
            if (rowNum != null && rowNum < 0L) {
                throw new IllegalArgumentException("rownum must be >= 0, part: " + name + ", rownum was: " + rowNum);
            }
            this.name = Objects.requireNonNull(name);
            this.rowNum = rowNum;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @Nullable Long getRowNum() {
            return this.rowNum;
        }

        public boolean isTableRow() {
            return this.rowNum != null;
        }

        public boolean isField() {
            return !this.isTableRow();
        }

        public @NonNull String toExternalForm() {
            if (this.isField()) {
                return this.name;
            }
            return this.name + DMK.PART_SEPARATOR + this.rowNum;
        }

        public String toString() {
            ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
            tsb.append((Object)this.name);
            if (this.isTableRow()) {
                tsb.append((Object)this.rowNum);
            }
            return tsb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Entry rhs = (Entry)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append((Object)this.rowNum, (Object)rhs.rowNum).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.name).append((Object)this.rowNum).toHashCode();
        }

        @Override
        public int compareTo(@NonNull Entry o) {
            return new CompareToBuilder().append((Object)this.name, (Object)o.name).append((Object)this.rowNum, (Object)o.rowNum).toComparison();
        }
    }
}

