/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.ejb.util;

import ch.dvbern.tax.common.ejb.util.DVEJB;
import ch.dvbern.tax.common.ejb.util.EJBBeanInjector;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.lang.reflect.Field;

public abstract class AbstractEJBBeanInjector
implements EJBBeanInjector {
    @Override
    public void instrumentEJBRelations(Object o) {
        Class<?> c = o.getClass();
        while (!c.equals(Object.class)) {
            this.instrumentEJBRelations(c, o);
            c = c.getSuperclass();
        }
    }

    @Override
    public void instrumentEJBRelations(Object o, String field) {
        Class<?> c = o.getClass();
        while (!c.equals(Object.class)) {
            this.instrumentEJBRelations(c, o, field);
            c = c.getSuperclass();
        }
    }

    private void instrumentEJBRelations(Class<?> c, Object o) {
        Field[] fields;
        for (Field field : fields = c.getDeclaredFields()) {
            if (field.getAnnotation(DVEJB.class) == null) continue;
            try {
                this.instrumentField(o, field);
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
        }
    }

    private void instrumentEJBRelations(Class<?> c, Object o, String fieldToInstrument) {
        Field[] fields;
        for (Field field : fields = c.getDeclaredFields()) {
            if (!fieldToInstrument.equals(field.getName()) || field.getAnnotation(DVEJB.class) == null) continue;
            try {
                this.instrumentField(o, field);
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
        }
    }

    public abstract void instrumentField(Object var1, Field var2) throws Exception;
}

