/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.cryptutil;

import ch.dvbern.lib.cryptutil.DigestFailedException;
import ch.dvbern.lib.cryptutil.Util;
import ch.dvbern.lib.cryptutil.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Objects;

public class DigestEngine {
    private static final int READ_BUFFER_SIZE = 4096;
    public static final String ALGO_SHA256 = "SHA-256";
    public static final String ALGO_SHA512 = "SHA-512";

    public boolean supportsSHA256(@Nullable Provider provider) {
        return this.supports(ALGO_SHA256, provider);
    }

    public byte[] digestSHA256(InputStream is, @Nullable Provider provider) throws IOException, DigestFailedException {
        return this.digestWithAlgo(is, ALGO_SHA256, provider);
    }

    public MessageDigest configureSHA256(@Nullable Provider provider) {
        try {
            return this.configureMessageDigest(ALGO_SHA256, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm: SHA-256", e);
        }
    }

    public boolean supportsSHA512(@Nullable Provider provider) {
        return this.supports(ALGO_SHA512, provider);
    }

    public byte[] digestSHA512(InputStream is, @Nullable Provider provider) throws IOException, DigestFailedException {
        return this.digestWithAlgo(is, ALGO_SHA512, provider);
    }

    public MessageDigest configureSHA512(@Nullable Provider provider) {
        try {
            return this.configureMessageDigest(ALGO_SHA512, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm: SHA-512", e);
        }
    }

    public boolean supports(String algorithm, @Nullable Provider provider) {
        try {
            this.configureMessageDigest(algorithm, provider);
            return true;
        }
        catch (NoSuchAlgorithmException ignored) {
            return false;
        }
    }

    public byte[] digestWithAlgo(InputStream is, String algorithm, @Nullable Provider provider) throws DigestFailedException, IOException {
        Objects.requireNonNull(is);
        Objects.requireNonNull(algorithm);
        MessageDigest md = null;
        try {
            md = this.configureMessageDigest(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestFailedException("No such algorithm: " + algorithm, e);
        }
        byte[] digest = this.digestFully(md, is);
        return digest;
    }

    private byte[] digestFully(MessageDigest md, InputStream is) throws IOException {
        Objects.requireNonNull(is);
        Objects.requireNonNull(md);
        Util.processFully(is, 4096, md::update);
        return md.digest();
    }

    public MessageDigest configureMessageDigest(String algorithm, @Nullable Provider provider) throws NoSuchAlgorithmException {
        Objects.requireNonNull(algorithm);
        return provider != null ? MessageDigest.getInstance(algorithm, provider) : MessageDigest.getInstance(algorithm);
    }
}

