/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.xjc.Arch;
import ch.dvbern.lib.update.xjc.OS;
import ch.dvbern.lib.update.xjc.VersionConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OsUtil {
    private static final Logger LOG = Logger.getLogger(OsUtil.class.getName());
    private static final String OS_WINDOWS = "Windows";
    private static final String OS_LINUX = "Linux";
    private static final String OS_MAC = "Mac OS X";
    private static final String ARCH_64 = "64";
    public static final String DIR_DOWNLOAD_PROGRESS = "version_update_progress";
    public static final String DIR_DOWNLOAD_COMPLETED = "version_update_complete";
    public static final String UPDATE_LOCK_FILE_NAME = "update.lck";
    private static final String SUN_JVM_ARCH_PROPERTY = "sun.arch.data.model";
    private static final int MAX_TRY_ACQUIRE_COUNT = 20;

    private OsUtil() {
    }

    public static String getArch() {
        String sunJvmArch = System.getProperty(SUN_JVM_ARCH_PROPERTY);
        return sunJvmArch != null ? sunJvmArch : System.getProperty("os.arch");
    }

    public static boolean isArch64() {
        return OsUtil.getArch().contains(ARCH_64);
    }

    public static boolean isArch32() {
        return !OsUtil.isArch64();
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isOsMac() {
        return OsUtil.getOsName().toLowerCase().contains(OS_MAC.toLowerCase());
    }

    public static boolean isOsLinux() {
        return OsUtil.getOsName().toLowerCase().contains(OS_LINUX.toLowerCase());
    }

    public static boolean isOsWindows() {
        return OsUtil.getOsName().toLowerCase().contains(OS_WINDOWS.toLowerCase());
    }

    public static boolean correctOperatingSystem(OS os) {
        if (os == null) {
            throw new NullPointerException("os cannot be null");
        }
        switch (os) {
            case ALL: {
                return true;
            }
            case WIN: {
                return OsUtil.isOsWindows();
            }
            case MAC: {
                return OsUtil.isOsMac();
            }
            case LINUX: {
                return OsUtil.isOsLinux();
            }
        }
        LOG.severe("Ignoring entry with unkown OS requirement: " + os);
        assert (false) : "Check generated API";
        return false;
    }

    public static boolean correctOsArch(Arch arch) {
        if (arch == null) {
            throw new NullPointerException("arch cannot be null");
        }
        switch (arch) {
            case ALL: {
                return true;
            }
            case ARCH_32: {
                return OsUtil.isArch32();
            }
            case ARCH_64: {
                return OsUtil.isArch64();
            }
        }
        LOG.severe("Ignoring entry with unkown arch requirement: " + arch);
        assert (false) : "Check generated API";
        return false;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static boolean isRunningOnJava14() {
        String javaVersion = OsUtil.getJavaVersion();
        return javaVersion.startsWith("1.4");
    }

    public static String getUserHome() {
        String userHome;
        if (OsUtil.isRunningOnJava14()) {
            userHome = System.getProperty("user.home");
        } else {
            userHome = System.getenv("USERPROFILE");
            if (userHome == null) {
                userHome = System.getProperty("user.home");
            }
        }
        return userHome;
    }

    public static File getAppUserDir(VersionConfig config) {
        if (config == null) {
            throw new NullPointerException("client version configuration cannot be null");
        }
        return new File(OsUtil.getUserHome(), config.getUserFolder());
    }

    public static File getUpdateLockFile(VersionConfig config) {
        if (config == null) {
            throw new NullPointerException("client version configuration cannot be null");
        }
        return new File(OsUtil.getAppUserDir(config), UPDATE_LOCK_FILE_NAME);
    }

    public static File getDownloadCompletedDir(VersionConfig config) {
        if (config == null) {
            throw new NullPointerException("client version configuration cannot be null");
        }
        return new File(OsUtil.getAppUserDir(config), DIR_DOWNLOAD_COMPLETED);
    }

    public static File getDownloadInProgressDir(VersionConfig config) {
        if (config == null) {
            throw new NullPointerException("client version configuration cannot be null");
        }
        return new File(OsUtil.getAppUserDir(config), DIR_DOWNLOAD_PROGRESS);
    }

    public static RandomAccessFile tryLock(File lockFile) throws IOException {
        return OsUtil.tryLockInternal(lockFile, false);
    }

    public static RandomAccessFile tryLockSilently(File lockFile) throws FileNotFoundException {
        try {
            return OsUtil.tryLockInternal(lockFile, true);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            assert (false) : "tryLockInternal throwed an IOException despite silent flag being set";
            return null;
        }
    }

    private static RandomAccessFile tryLockInternal(File lockFile, boolean silent) throws IOException {
        if (lockFile == null) {
            throw new NullPointerException("lock file cannot be null");
        }
        RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
        LOG.fine("Try acquirring lock for " + lockFile.getAbsolutePath());
        try {
            if (raf.getChannel().tryLock() != null) {
                LOG.info("Lock acquired for " + lockFile.getAbsolutePath());
                return raf;
            }
            LOG.info("Cannot acquire lock, the file is used by another process");
        }
        catch (OverlappingFileLockException e) {
            LOG.log(Level.INFO, "Cannot acquire lock, the file is used by another thread");
        }
        catch (IOException e) {
            if (!silent) {
                throw e;
            }
            LOG.log(Level.WARNING, "I/O error while acquirring the lock to " + lockFile.getAbsolutePath() + ", assume that the current system has no file locking capability", e);
            return raf;
        }
        IOUtils.closeQuietly(raf);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessFile tryLock(final File lockFile, long timeout, TimeUnit unit) throws IOException, InterruptedException {
        block13: {
            if (lockFile == null || unit == null) {
                throw new NullPointerException("Invalid null argument");
            }
            if (timeout == 0L) {
                return OsUtil.tryLock(lockFile);
            }
            Callable<RandomAccessFile> task = new Callable<RandomAccessFile>(){

                @Override
                public RandomAccessFile call() throws Exception {
                    RandomAccessFile updateLock = new RandomAccessFile(lockFile, "rw");
                    try {
                        updateLock.getChannel().lock();
                    }
                    catch (FileLockInterruptionException e) {
                        LOG.finer("FileLock-wait interrupted");
                        IOUtils.closeQuietly(updateLock);
                        return null;
                    }
                    return updateLock;
                }
            };
            ExecutorService exec = Executors.newSingleThreadExecutor();
            try {
                RandomAccessFile randomAccessFile = exec.submit(task).get(timeout, unit);
                return randomAccessFile;
            }
            catch (TimeoutException e) {
                LOG.info("Timeout while waiting for the lock file");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof OverlappingFileLockException) {
                    LOG.log(Level.INFO, "Cannot acquire lock, the file is used by another thread", e);
                    break block13;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("Undeclared throwable", e);
            }
            finally {
                exec.shutdownNow();
            }
        }
        return null;
    }

    public static OutputStream tryAcquireFile(File file) throws FileNotFoundException, InterruptedException {
        FileOutputStream out;
        if (file == null) {
            throw new NullPointerException();
        }
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            int c = 0;
            while (file.exists() && c++ < 20) {
                try {
                    LOG.finer("Cannot access file, sleep for a while");
                    Thread.sleep(500L);
                    FileOutputStream out2 = new FileOutputStream(file);
                    LOG.finer("Got it!");
                    return out2;
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            throw e;
        }
        return out;
    }
}

