/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Pattern;

public class LibUpdateVersion
implements Comparable<LibUpdateVersion> {
    private static final String MAVEN_PROP_FILE_RES = "/META-INF/maven/ch.dvbern.lib/dvbern-lib-update/pom.properties";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private static final String VERSION_DELIMITER = ".";
    private static final Pattern VERSION_DELIMITER_PTN = Pattern.compile(Pattern.quote("."));
    private static final int VERSION_TOKEN_COUNT = 3;
    private final Integer[] versionArray;

    private LibUpdateVersion(Integer[] versionArray) {
        assert (versionArray != null);
        this.versionArray = Arrays.copyOf(versionArray, versionArray.length);
    }

    public static LibUpdateVersion getCurrentVersion() {
        return LibUpdateVersion.resolveCurrentVersion();
    }

    private static LibUpdateVersion resolveCurrentVersion() {
        String versionString;
        InputStream mavenProps = LibUpdateVersion.class.getResourceAsStream(MAVEN_PROP_FILE_RES);
        if (mavenProps == null) {
            throw new IllegalStateException("Cannot locate maven properties file");
        }
        try {
            Properties props = new Properties();
            props.load(mavenProps);
            versionString = props.getProperty("version");
            if (versionString == null) {
                throw new IllegalStateException("Cannot find version poperty in maven properties file");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse maven properties file", e);
        }
        finally {
            IOUtils.closeQuietly(mavenProps);
        }
        try {
            return LibUpdateVersion.parse(versionString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Failed to parse maven artifact version", e);
        }
    }

    public static LibUpdateVersion parse(String version) {
        Object[] versionTokens;
        if (version == null) {
            throw new NullPointerException("Version string cannot be null");
        }
        if (version.endsWith(SNAPSHOT_SUFFIX)) {
            assert (version.length() - SNAPSHOT_SUFFIX.length() > 0);
            version = version.substring(0, version.length() - SNAPSHOT_SUFFIX.length());
        }
        if ((versionTokens = VERSION_DELIMITER_PTN.split(version)).length != 3) {
            throw new IllegalArgumentException("Invalid token count in version string: " + Arrays.toString(versionTokens));
        }
        Integer[] versionArray = new Integer[3];
        for (int i = 0; i < versionArray.length; ++i) {
            try {
                Integer val = Integer.valueOf((String)versionTokens[i]);
                if (val < 0) {
                    throw new IllegalArgumentException("Version numbers must be positive: " + Arrays.toString(versionTokens));
                }
                versionArray[i] = val;
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number token in version string: " + Arrays.toString(versionTokens), e);
            }
        }
        return new LibUpdateVersion(versionArray);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Integer i : this.versionArray) {
            if (sb.length() > 0) {
                sb.append(VERSION_DELIMITER_PTN);
            }
            sb.append(i);
        }
        return Arrays.toString((Object[])this.versionArray);
    }

    @Override
    public int compareTo(LibUpdateVersion o) {
        if (o == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.versionArray.length; ++i) {
            int res = this.versionArray[i].compareTo(o.versionArray[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibUpdateVersion)) {
            return false;
        }
        LibUpdateVersion that = (LibUpdateVersion)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.versionArray);
    }
}

