/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.DialogsUtil;
import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.LibUpdateConfig;
import ch.dvbern.lib.update.Messages;
import ch.dvbern.lib.update.OsUtil;
import ch.dvbern.lib.update.UpdateManager;
import ch.dvbern.lib.update.VersionNumber;
import ch.dvbern.lib.update.VersionUtil;
import ch.dvbern.lib.update.elevate.ElevationFailedException;
import ch.dvbern.lib.update.elevate.IPrivilegesElevator;
import ch.dvbern.lib.update.elevate.PrivilegesElevatorPriorityComparator;
import ch.dvbern.lib.update.exception.CauseType;
import ch.dvbern.lib.update.exception.ConfigurationException;
import ch.dvbern.lib.update.exception.OutdatedBootstrapException;
import ch.dvbern.lib.update.exception.UpdateFailureException;
import ch.dvbern.lib.update.xjc.ClassPath;
import ch.dvbern.lib.update.xjc.ClassPathEntry;
import ch.dvbern.lib.update.xjc.VersionConfig;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JDialog;

public final class Launcher {
    private static final Logger LOG = Logger.getLogger(Launcher.class.getName());
    public static final String RUN_ELEVATED_FLAG = "--elevated";
    public static final String BOOTSTRAP_UPDATE_FLAG = "--bootstrap-update";
    public static final String APP_ARGS = "--appArgs";
    public static final String TARGET_DIR_ARG = "--targetDir";
    public static final String USER_HOME_DIR_ARG = "--userHome";

    private Launcher() {
    }

    public static void main(String[] args) throws IOException {
        LibUpdateConfig.getInstance().applySystemProperties();
        Launcher.initLogging();
        String userHomePath = OsUtil.getUserHome();
        String targetDirPath = System.getProperty("user.dir");
        boolean runElevated = false;
        boolean bootstrapUpdate = false;
        Object[] appArgs = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String[] argPair = arg.split("=");
            if (argPair.length == 2) {
                String name = argPair[0];
                String value = argPair[1];
                if (TARGET_DIR_ARG.equals(name)) {
                    targetDirPath = value;
                    continue;
                }
                if (USER_HOME_DIR_ARG.equals(name)) {
                    userHomePath = value;
                    continue;
                }
                LOG.log(Level.SEVERE, "Unkown arg: " + name);
                continue;
            }
            if (RUN_ELEVATED_FLAG.equals(arg)) {
                runElevated = true;
                continue;
            }
            if (BOOTSTRAP_UPDATE_FLAG.equals(arg)) {
                bootstrapUpdate = true;
                continue;
            }
            if (APP_ARGS.equals(arg)) {
                int srcPos = i + 1;
                if (srcPos >= args.length) continue;
                int length = args.length - srcPos;
                appArgs = new String[length];
                System.arraycopy(args, srcPos, appArgs, 0, length);
                continue;
            }
            LOG.log(Level.SEVERE, "Unkown arg: " + arg);
        }
        File userHome = new File(userHomePath);
        File targetDir = new File(targetDirPath);
        if (appArgs == null) {
            appArgs = new String[]{};
        }
        try {
            VersionConfig config;
            block21: {
                config = VersionUtil.loadVersionConfig();
                File appUserDir = new File(userHome, config.getUserFolder());
                appUserDir.mkdirs();
                Launcher.setupAppLog(appUserDir, config.getLogFile(), runElevated, bootstrapUpdate);
                LOG.info("Lib-update starting on " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + ". targetDir: " + targetDir.getAbsolutePath() + " userHome: " + userHome.getAbsolutePath() + " runElevated: " + runElevated + " bootstrapUpdate: " + bootstrapUpdate + " appArgs: " + Arrays.toString(appArgs));
                for (String a : args) {
                    LOG.info("---------ARGUMENT: " + a);
                }
                LOG.info("Target application " + config.getAppName() + " " + config.getVersion());
                try {
                    Launcher.processUpdates(userHome, appUserDir, targetDir, config, runElevated, bootstrapUpdate, (String[])appArgs);
                }
                catch (UpdateFailureException e) {
                    LOG.log(Level.SEVERE, "Update failed", e);
                    DialogsUtil.showErrorDialog("update.failure", config.getAppName());
                }
                catch (ElevationFailedException e) {
                    Launcher.logEverywhere(e);
                    DialogsUtil.showErrorDialog("update.failure.permission", config.getAppName());
                }
                catch (OutdatedBootstrapException e) {
                    LOG.info("An updated version of the boostrap file is available");
                    Launcher.rebootWithUpdatedBootstrap(config, e.getNewBootstrap(), appUserDir, targetDir, userHome, runElevated, (String[])appArgs);
                    if ($assertionsDisabled) break block21;
                    throw new AssertionError((Object)"Unreachable code path");
                }
            }
            if (!runElevated) {
                if (!bootstrapUpdate) {
                    LOG.info("Proceeding with normal startup.");
                    Launcher.launchApplication(targetDir, (String[])appArgs, config);
                } else {
                    File bootstrap = new File(targetDir, config.getBootstrap());
                    List<String> command = Launcher.prepareBootstrapCommand(bootstrap, targetDir, userHome, false, false, (String[])appArgs);
                    ProcessBuilder pb = new ProcessBuilder(command);
                    pb.directory(targetDir);
                    LOG.info("Bootstrap updated, performing re-launch: " + command);
                    pb.start();
                }
            } else {
                LOG.info("Exiting elevated mode now.");
            }
        }
        catch (InvocationTargetException e) {
            LOG.log(Level.SEVERE, "Exception in target application", e);
            System.exit(1);
        }
        catch (ConfigurationException e) {
            LOG.log(Level.SEVERE, "Invalid configuration", e);
            System.exit(1);
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "Current thread has been interrupted, exiting at once");
            System.exit(1);
        }
    }

    private static void logEverywhere(ElevationFailedException e) {
        e.printStackTrace();
        LOG.log(Level.SEVERE, "Elevation failed", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebootWithUpdatedBootstrap(VersionConfig config, File updatedBootstrap, File appUserDir, File targetDir, File userHome, boolean runElevated, String[] appArgs) {
        File lockFile = new File(appUserDir, "update.lck");
        RandomAccessFile updateLock = null;
        try {
            File newJRE;
            File updateDir = updatedBootstrap.getParentFile();
            if (updateDir == null) {
                throw new IOException("Update directory has no parent.");
            }
            String bundledJREPath = config.getBundledJRE();
            if (!VersionUtil.isBlank(bundledJREPath) && !(newJRE = new File(updateDir, bundledJREPath)).exists()) {
                File currentJRE = new File(targetDir, bundledJREPath);
                if (currentJRE.isDirectory()) {
                    try {
                        IOUtils.copyDirectory(currentJRE, newJRE);
                    }
                    catch (IOException e) {
                        LOG.log(Level.WARNING, "Failed to copy JRE, starting new bootstrap may fail!", e);
                    }
                } else {
                    LOG.warning("Cannot locate current JRE directory, starting new bootstrap may fail!");
                }
            }
            IOUtils.markExecutable(updatedBootstrap);
            List<String> command = Launcher.prepareBootstrapCommand(updatedBootstrap, targetDir, userHome, runElevated, true, appArgs);
            LOG.info("Starting updated bootstrap: " + command);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(updatedBootstrap.getParentFile());
            updateLock = OsUtil.tryLockSilently(lockFile);
            pb.start();
            System.exit(0);
            IOUtils.closeQuietly(updateLock);
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Update failed", ioe);
            DialogsUtil.showErrorDialog("update.failure", config.getAppName());
        }
        finally {
            IOUtils.closeQuietly(updateLock);
        }
        assert (false) : "Unreachable code path";
    }

    private static List<String> prepareBootstrapCommand(File bootstrap, File targetDir, File userHome, boolean runElevated, boolean bootstrapUpdate, String[] appArgs) {
        assert (bootstrap != null && targetDir != null && userHome != null && appArgs != null);
        ArrayList<String> command = new ArrayList<String>();
        command.add(bootstrap.getAbsolutePath());
        command.add("--targetDir=" + targetDir.getAbsolutePath());
        command.add("--userHome=" + userHome.getAbsolutePath());
        if (runElevated) {
            command.add(RUN_ELEVATED_FLAG);
        }
        if (bootstrapUpdate) {
            command.add(BOOTSTRAP_UPDATE_FLAG);
        }
        if (appArgs.length > 0) {
            command.add(APP_ARGS);
            Collections.addAll(command, appArgs);
        }
        return command;
    }

    private static void initLogging() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.log(Level.SEVERE, "Uncaught exception for thread " + t, e);
            }
        });
        try {
            LogManager.getLogManager().readConfiguration(Launcher.class.getResourceAsStream("/logging.properties"));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to apply logging configuration", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL[] prepareClasspath(File targetDir, ClassPath cp) throws ConfigurationException {
        assert (targetDir != null && cp != null);
        List<ClassPathEntry> entries = cp.getEntries();
        LinkedHashSet<URI> uriSet = new LinkedHashSet<URI>();
        for (ClassPathEntry entry : entries) {
            File f;
            block18: {
                if (!OsUtil.correctOperatingSystem(entry.getOs()) || !OsUtil.correctOsArch(entry.getArch())) continue;
                f = new File(targetDir, entry.getValue());
                uriSet.add(f.toURI());
                if (!f.exists()) {
                    LOG.warning(f.getAbsolutePath() + " does not exists");
                    continue;
                }
                if (!f.getName().endsWith(".jar")) break block18;
                JarFile jf = null;
                try {
                    StringBuilder sb;
                    block19: {
                        jf = new JarFile(f);
                        String jarVersion = null;
                        String jarClasspath = null;
                        Manifest mf = jf.getManifest();
                        if (mf != null) {
                            Attributes attrs = jf.getManifest().getMainAttributes();
                            jarVersion = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                            jarClasspath = attrs.getValue(Attributes.Name.CLASS_PATH);
                        }
                        sb = new StringBuilder();
                        sb.append("Added ").append(f).append(" (version: ").append(jarVersion != null ? jarVersion : "na").append(") to classpath");
                        if (jarClasspath == null || !LOG.isLoggable(Level.FINE)) break block19;
                        sb.append(" with 1th level classpath entries: ");
                        for (String jarClasspathEntry : jarClasspath.split(" +")) {
                            block20: {
                                Object detail;
                                if (!jarClasspathEntry.endsWith(".jar")) break block20;
                                File jarClasspathFile = new File(f.getParent(), jarClasspathEntry);
                                JarFile subJar = null;
                                try {
                                    subJar = new JarFile(jarClasspathFile);
                                    String subJarVersion = null;
                                    mf = subJar.getManifest();
                                    if (mf != null) {
                                        subJarVersion = mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                                    }
                                    detail = "version: " + (subJarVersion != null ? subJarVersion : "na");
                                }
                                catch (IOException e) {
                                    try {
                                        detail = e.getMessage();
                                    }
                                    catch (Throwable throwable) {
                                        IOUtils.closeQuietly(subJar);
                                        throw throwable;
                                    }
                                    IOUtils.closeQuietly(subJar);
                                }
                                IOUtils.closeQuietly(subJar);
                                sb.append(jarClasspathEntry).append("(").append((String)detail).append(") ");
                                continue;
                            }
                            sb.append(jarClasspathEntry).append(" ");
                        }
                    }
                    LOG.fine(sb.toString());
                }
                catch (IOException e) {
                    try {
                        LOG.log(Level.WARNING, "Cannot access jar file " + f.getAbsolutePath(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(jf);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(jf);
                    continue;
                }
                IOUtils.closeQuietly(jf);
                continue;
            }
            LOG.fine("Added " + f + " to classpath");
        }
        if (uriSet.isEmpty()) {
            LOG.warning("Resulting class path is empty");
        }
        URL[] classpath = new URL[uriSet.size()];
        Iterator itr = uriSet.iterator();
        int i = 0;
        while (itr.hasNext()) {
            URI uri = (URI)itr.next();
            try {
                classpath[i++] = uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("Invalid classpath entry: " + uri);
            }
        }
        return classpath;
    }

    private static void setupAppLog(File appUserDir, String logFile, boolean runElevated, boolean bootstrapUpdate) {
        FileHandler fh;
        assert (appUserDir != null);
        if (logFile == null || logFile.trim().isEmpty()) {
            logFile = "startup.log";
        }
        File log = new File(appUserDir, logFile);
        File logDir = log.getParentFile();
        if (runElevated) {
            log = new File(logDir, "elevated_" + log.getName());
        }
        if (bootstrapUpdate) {
            PrintStream redirectStream;
            try {
                redirectStream = new PrintStream(new File(logDir, "stdout_" + log.getName()));
            }
            catch (FileNotFoundException e) {
                redirectStream = new PrintStream(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                    }
                });
            }
            System.setOut(redirectStream);
            System.setErr(redirectStream);
        }
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        try {
            fh = new FileHandler(log.getAbsolutePath(), true);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to setup log file", e);
            return;
        }
        fh.setLevel(Level.ALL);
        fh.setFormatter(new SimpleFormatter());
        Logger.getLogger("").addHandler(fh);
        Logger.getLogger("ch.dvbern").setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processUpdates(File userHome, File appUserDir, File targetDir, VersionConfig config, boolean elevated, boolean bootstrapUpdate, String[] appArgs) throws UpdateFailureException, ElevationFailedException, OutdatedBootstrapException, InterruptedException {
        assert (userHome != null && appUserDir != null && targetDir != null && config != null);
        File updateDir = !bootstrapUpdate ? new File(appUserDir, "version_update_complete") : new File(".");
        LOG.fine("Checking directory " + updateDir.getAbsolutePath() + " for updates");
        if (!updateDir.isDirectory()) {
            LOG.info("No update to apply: " + updateDir.getAbsolutePath());
            return;
        }
        JDialog dlg = DialogsUtil.createWaitDialog("dialog.wait.copy");
        try {
            RandomAccessFile updateLock;
            block13: {
                DialogsUtil.showDialog(dlg);
                File lockFile = new File(appUserDir, "update.lck");
                try {
                    updateLock = bootstrapUpdate && !elevated ? OsUtil.tryLock(lockFile, 20L, TimeUnit.SECONDS) : OsUtil.tryLock(lockFile);
                    if (updateLock != null) break block13;
                    if (elevated) {
                        LOG.info("Cannot acquire the update lock, assuming that the base process owns it");
                        break block13;
                    }
                    LOG.info("Cannot acquire the update lock, returning");
                    return;
                }
                catch (FileNotFoundException e) {
                    throw new UpdateFailureException(CauseType.FILESYSTEM, "Failure to access lock file", e);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "I/O error while acquirring the update lock, assume that the current system has no file locking capability", e);
                    updateLock = null;
                    if (!bootstrapUpdate) break block13;
                    Thread.sleep(3000L);
                }
            }
            try {
                Launcher.processLockedUpdate(userHome, updateDir, targetDir, config, elevated, bootstrapUpdate, appArgs);
            }
            finally {
                IOUtils.closeQuietly(updateLock);
            }
        }
        finally {
            DialogsUtil.disposeDialog(dlg);
        }
    }

    private static void processLockedUpdate(File userHome, File updateDir, File targetDir, VersionConfig config, boolean elevated, boolean bootstrapUpdate, String[] appArgs) throws ElevationFailedException, OutdatedBootstrapException, InterruptedException, UpdateFailureException {
        if (!bootstrapUpdate) {
            VersionConfig updatedConfig;
            try {
                updatedConfig = VersionUtil.loadVersionConfig(updateDir);
            }
            catch (ConfigurationException e) {
                LOG.log(Level.SEVERE, "Cannot parse updated client version configuration", e);
                IOUtils.deleteFileOrDirectory(updateDir);
                return;
            }
            VersionNumber version = VersionNumber.parse(config.getVersion());
            VersionNumber updatedVersion = VersionNumber.parse(updatedConfig.getVersion());
            if (updatedVersion.compareTo(version) <= 0) {
                LOG.warning("Ignoring out-dated update " + updatedVersion + " (current: " + version + ")");
                if (!IOUtils.deleteFileOrDirectory(updateDir)) {
                    LOG.severe("Failed to remove update directory");
                }
                return;
            }
            File updatedBootstrap = new File(updateDir, updatedConfig.getBootstrap());
            if (updatedBootstrap.isFile()) {
                throw new OutdatedBootstrapException(updatedBootstrap);
            }
        }
        if (!Launcher.canWrite(targetDir)) {
            if (elevated) {
                throw new UpdateFailureException(CauseType.FILESYSTEM, "Cannot write in target directory despite elevation.");
            }
            LOG.info("Target directory not writeable, will attempt process elevation");
            Launcher.tryRunElevated(userHome, targetDir, config, bootstrapUpdate, appArgs);
            LOG.info("Elevated update terminated, no error reported.");
            return;
        }
        LOG.info("Start updating installation...");
        LOG.info("Do not sleep anymore, try lock instead");
        try {
            File bootstrapFile = new File(targetDir, config.getBootstrap());
            if (bootstrapUpdate) {
                OsUtil.tryAcquireFile(bootstrapFile).close();
            }
            List<String> cleanList = Launcher.loadCleanList(updateDir);
            for (String toBeCleaned : cleanList) {
                File f = new File(targetDir, toBeCleaned);
                if (!f.exists()) continue;
                try {
                    if (IOUtils.isParentDir(targetDir, f)) {
                        IOUtils.deleteFileOrDirectory(f);
                        continue;
                    }
                    LOG.log(Level.WARNING, "Child file " + f.getAbsolutePath() + " seems to be outside application directory, " + targetDir.getAbsolutePath() + ", ignoring delete request.");
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to check parent-child relationship between: " + targetDir.getAbsolutePath() + " and " + f.getAbsolutePath(), e);
                }
            }
            IOUtils.copyDirectory(updateDir, targetDir);
            if (bootstrapUpdate) {
                IOUtils.markExecutable(bootstrapFile);
            }
            if (!IOUtils.deleteFileOrDirectory(updateDir)) {
                LOG.severe("Failed to remove update directory");
            }
        }
        catch (IOException e) {
            throw new UpdateFailureException(CauseType.FILESYSTEM, "Failed to copy new files", e);
        }
    }

    private static boolean canWrite(File targetDir) {
        assert (targetDir != null);
        try {
            File f = File.createTempFile("wr_tst_", null, targetDir);
            f.delete();
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "Cannot create file in " + targetDir.getAbsolutePath() + ", assuming not writable", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadCleanList(File updateDir) throws IOException {
        assert (updateDir != null);
        File cleanListFile = new File(updateDir, "clean-list.txt");
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cleanListFile), UpdateManager.UTF_8));
            ArrayList<String> cleanList = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                cleanList.add(line);
            }
            cleanListFile.delete();
            ArrayList<String> arrayList = cleanList;
            IOUtils.closeQuietly(reader);
            return arrayList;
        }
        catch (FileNotFoundException e) {
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private static void tryRunElevated(File userHome, File targetDir, VersionConfig config, boolean bootstrapUpdate, String[] appArgs) throws ElevationFailedException, InterruptedException {
        assert (userHome != null && targetDir != null && config != null);
        File bootstrap = new File(config.getBootstrap());
        List<String> command = Launcher.prepareBootstrapCommand(bootstrap, targetDir, userHome, true, bootstrapUpdate, appArgs);
        String prompt = Messages.getString("update.prompt", config.getAppName(), config.getVersion());
        String[] cmd = command.toArray(new String[command.size()]);
        PriorityQueue<IPrivilegesElevator> pq = new PriorityQueue<IPrivilegesElevator>(11, new PrivilegesElevatorPriorityComparator());
        for (IPrivilegesElevator elevator : ServiceLoader.load(IPrivilegesElevator.class)) {
            if (elevator.supportsCurrentSystem()) {
                pq.add(elevator);
                continue;
            }
            LOG.finer("Ignoring unsupported elevator: " + elevator.getClass().getName());
        }
        if (pq.isEmpty()) {
            throw new ElevationFailedException("Cannot find a suitable elevator");
        }
        for (IPrivilegesElevator elevator : pq) {
            String elevatorName = elevator.getClass().getName();
            try {
                assert (elevator.supportsCurrentSystem());
                String icon = System.getProperty(elevator.getClass().getName() + ".icon");
                ProcessBuilder builder = elevator.createElevatedProcessBuilder(cmd, prompt, icon);
                builder.redirectErrorStream(true);
                LOG.info("Using elevator " + elevatorName + " with command " + builder.command());
                Process p = builder.start();
                ByteArrayOutputStream stdoutAndErr = new ByteArrayOutputStream();
                IOUtils.copy(p.getInputStream(), stdoutAndErr);
                LOG.info("[elevated]=>" + new String(stdoutAndErr.toByteArray()));
                int code = p.waitFor();
                if (elevator.processExitCode(code)) break;
                LOG.fine("Elevator delegated exit code processing");
                if (code != 0) {
                    throw new ElevationFailedException("Non-zero error code returned by updater: " + code);
                }
                break;
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Cannot start process for elevator " + elevatorName + " attempt to find another elevator candidate.", e);
            }
        }
    }

    private static void launchApplication(File targetDir, String[] appArgs, VersionConfig config) throws ConfigurationException, InvocationTargetException {
        assert (targetDir != null && config != null && appArgs != null);
        URLClassLoader loader = new URLClassLoader(Launcher.prepareClasspath(targetDir, config.getClassPath()));
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Class<?> c = loader.loadClass(config.getMainClass());
            Method m = c.getMethod("main", String[].class);
            LOG.info("Invoking target application now: " + c.getName() + " with args " + Arrays.toString(appArgs));
            m.invoke(null, new Object[]{appArgs});
            LOG.info("End of of target application invocation");
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Cannot find main class", e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Specified class do not contains a valid main metod", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to access main method", e);
        }
    }
}

