/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update;

import ch.dvbern.lib.update.Messages;
import ch.dvbern.lib.update.OsUtil;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DialogsUtil {
    private static final Logger LOG = Logger.getLogger(DialogsUtil.class.getName());

    private DialogsUtil() {
    }

    public static JDialog createWaitDialog(String key) {
        return DialogsUtil.createWaitDialog(key, null);
    }

    public static void showDialog(final JDialog dlg) {
        if (dlg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dlg.setVisible(true);
                }
            });
        }
    }

    public static void disposeDialog(final JDialog dlg) {
        if (dlg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dlg.setVisible(false);
                    dlg.dispose();
                }
            });
        }
    }

    public static JDialog createWaitDialog(String key, Object ... params) {
        if (OsUtil.isOsMac()) {
            return null;
        }
        if (key == null) {
            throw new NullPointerException("message key cannot be null");
        }
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        final String message = params != null ? Messages.getString(key, params) : Messages.getString(key);
        FutureTask<JDialog> task = new FutureTask<JDialog>(new Callable<JDialog>(){

            @Override
            public JDialog call() throws Exception {
                JDialog dlg = new JOptionPane(message, 1, -1, null, new Object[0], null).createDialog(null, Messages.getString("dialog.wait.title"));
                dlg.setDefaultCloseOperation(0);
                return dlg;
            }
        });
        SwingUtilities.invokeLater(task);
        try {
            return task.get();
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            DialogsUtil.dispatchThrowable(e.getCause());
        }
        return null;
    }

    public static void showErrorDialog(String key) {
        DialogsUtil.showErrorDialog(key, null);
    }

    public static void showErrorDialog(String key, Object ... params) {
        DialogsUtil.showDialog(key, params, "dialog.error.title", 0);
    }

    private static void showDialog(String key, Object[] params, String titleKey, final int messageType) {
        String message;
        if (key == null || titleKey == null) {
            throw new NullPointerException("message keys cannot be null");
        }
        final String title = Messages.getString(titleKey);
        String string = message = params != null ? Messages.getString(key, params) : Messages.getString(key);
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, message, title, messageType);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DialogsUtil.dispatchThrowable(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            System.out.print(title + ": " + message);
        }
    }

    private static void dispatchThrowable(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException("Undeclared throwable", e);
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to set native look&feel", e);
            }
        }
    }
}

