/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.proxy.MonProxyLabelerInt;
import com.jamonapi.proxy.Params;
import com.jamonapi.utils.Logger;
import com.jamonapi.utils.Misc;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;

public class MonProxy
implements InvocationHandler {
    private Object monitoredObj;
    Params params;
    private MonProxyLabelerInt labelerInt;
    private static Method EQUALS_METHOD;

    MonProxy(Object monitoredObj, Params params, MonProxyLabelerInt labelerInt) {
        this.monitoredObj = monitoredObj;
        this.params = params;
        this.labelerInt = labelerInt;
        this.labelerInt.init(this);
    }

    public Object getMonitoredObject() {
        return MonProxy.getMonitoredObject(this.monitoredObj);
    }

    public static Object getMonitoredObject(Object obj) {
        if (obj == null) {
            return null;
        }
        while (Proxy.isProxyClass(obj.getClass()) && Proxy.getInvocationHandler(obj) instanceof MonProxy) {
            MonProxy monProxy = (MonProxy)Proxy.getInvocationHandler(obj);
            obj = monProxy.getMonitoredObject();
        }
        return obj;
    }

    public void setLabeler(MonProxyLabelerInt labelerInt) {
        this.labelerInt = labelerInt;
    }

    public MonProxyLabelerInt getLabeler() {
        return this.labelerInt;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Monitor mon = null;
        if (this.params.isInterfaceEnabled && this.params.isEnabled) {
            mon = MonitorFactory.start(this.labelerInt.getSummaryLabel(method));
        }
        try {
            if (method.equals(EQUALS_METHOD)) {
                Boolean bl = this.equals(args[0]);
                return bl;
            }
            Object object = method.invoke(this.monitoredObj, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (this.params.isEnabled) {
                String sqlMessage = "";
                Object detailStackTrace = null;
                Throwable rootCause = e.getCause();
                if (rootCause instanceof SQLException) {
                    SQLException sqlException = (SQLException)rootCause;
                    sqlMessage = ",ErrorCode=" + sqlException.getErrorCode() + ",SQLState=" + sqlException.getSQLState();
                }
                this.trackException(rootCause, method, sqlMessage);
            }
            throw e.getCause();
        }
        finally {
            if (mon != null) {
                mon.stop();
            }
        }
    }

    private void trackException(Throwable rootCause, Method method, String sqlMessage) {
        String detailStackTrace = Misc.getExceptionTrace(rootCause);
        MonitorFactory.add(new MonKeyImp("com.jamonapi.Exceptions", detailStackTrace, "Exception"), 1.0);
        MonitorFactory.add(new MonKeyImp("MonProxy-Exception: InvocationTargetException", detailStackTrace, "Exception"), 1.0);
        MonitorFactory.add(new MonKeyImp("MonProxy-Exception: Root cause exception=" + rootCause.getClass().getName() + sqlMessage, detailStackTrace, "Exception"), 1.0);
        MonitorFactory.add(new MonKeyImp(this.labelerInt.getExceptionLabel(method), detailStackTrace, "Exception"), 1.0);
    }

    public boolean equals(Object obj) {
        return this.getMonitoredObject().equals(MonProxy.getMonitoredObject(obj));
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
        }
        catch (Exception e) {
            Logger.log("Error trying to create reflective equals method.  This error should never happen: " + e);
        }
    }
}

