/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.aop.spring;

import com.jamonapi.aop.spring.JamonAopKeyHelperInt;
import com.jamonapi.utils.Misc;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;

@Component
public class JamonAopKeyHelper
implements JamonAopKeyHelperInt<ProceedingJoinPoint> {
    private boolean useArgsWithMethodDetails = false;
    private boolean useArgsWithExceptionDetails = false;

    public JamonAopKeyHelper() {
    }

    public JamonAopKeyHelper(boolean useArgsWithMethodDetails, boolean useArgsWithExceptionDetails) {
        this.useArgsWithMethodDetails = useArgsWithMethodDetails;
        this.useArgsWithExceptionDetails = useArgsWithExceptionDetails;
    }

    @Override
    public void setUseArgsWithMethodDetails(boolean useArgsWithMethodDetails) {
        this.useArgsWithMethodDetails = useArgsWithMethodDetails;
    }

    @Override
    public void setUseArgsWithExceptionDetails(boolean useArgsWithExceptionDetails) {
        this.useArgsWithExceptionDetails = useArgsWithExceptionDetails;
    }

    @Override
    public String getLabel(ProceedingJoinPoint proceedingJoinPoint) {
        return proceedingJoinPoint.getSignature().toString();
    }

    @Override
    public String getExceptionLabel(Throwable exception) {
        return exception.getClass().getName();
    }

    @Override
    public String getDetails(ProceedingJoinPoint proceedingJoinPoint) {
        String signature = this.getLabel(proceedingJoinPoint);
        return this.createDetailMessage(proceedingJoinPoint, signature, this.useArgsWithMethodDetails);
    }

    @Override
    public String getDetails(ProceedingJoinPoint proceedingJoinPoint, Throwable exception) {
        String detailMessage = this.createDetailMessage(proceedingJoinPoint, "", this.useArgsWithExceptionDetails);
        String stackTrace = new StringBuffer(detailMessage).append("\n\nstackTrace=").append(Misc.getExceptionTrace(exception)).toString();
        return stackTrace;
    }

    private void appendArgs(StringBuilder sb, Object[] args) {
        if (args == null) {
            return;
        }
        int lastElement = args.length - 1;
        for (int i = 0; i <= lastElement; ++i) {
            if (i == 0) {
                sb.append("\narguments(").append(args.length).append("):\n");
            }
            sb.append(args[i]);
            if (lastElement == 0 || i == lastElement) continue;
            sb.append(",\n");
        }
    }

    private String createDetailMessage(ProceedingJoinPoint proceedingJoinPoint, String baseMessage, boolean useArgsInDetails) {
        if (useArgsInDetails) {
            StringBuilder sb = new StringBuilder().append(baseMessage);
            this.appendArgs(sb, proceedingJoinPoint.getArgs());
            return sb.toString();
        }
        return baseMessage;
    }
}

