/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MonitorCompositeIterator
implements Iterator<Monitor> {
    private Iterator<MonitorComposite> iter;
    private MonitorComposite currentMonitorComposite;
    private int index = -1;

    public MonitorCompositeIterator(Collection<MonitorComposite> monitorComposites) {
        this.iter = monitorComposites.iterator();
        this.currentMonitorComposite = this.iter.next();
    }

    @Override
    public boolean hasNext() {
        boolean hasMore = this.index < this.currentMonitorComposite.getNumRows() - 1 ? true : this.setNextMonitorComposite();
        ++this.index;
        return hasMore;
    }

    private boolean setNextMonitorComposite() {
        this.index = -1;
        if (this.iter.hasNext()) {
            this.currentMonitorComposite = this.iter.next();
            return this.currentMonitorComposite.getNumRows() > 0;
        }
        return false;
    }

    @Override
    public Monitor next() {
        return this.currentMonitorComposite.getMonitors()[this.index];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported in this class");
    }

    public MonitorComposite getCurrentMonitorComposite() {
        return this.currentMonitorComposite;
    }

    public MonitorComposite toMonitorComposite() {
        return new MonitorComposite(this.toList().toArray(new Monitor[0]));
    }

    public List<Monitor> toList() {
        ArrayList<Monitor> list = new ArrayList<Monitor>();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return list;
    }
}

