/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.lib.resource.construct.xml.ClassFactory;
import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.PrimObjectFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class PrimParser
implements ElementParser {
    private static final Set<String> ALLOWED_ELEMENT_NAMES;

    @Override
    @Nonnull
    public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
        Object value;
        Class klass;
        String elementName = element.getNodeName();
        if (!ALLOWED_ELEMENT_NAMES.contains(elementName)) {
            throw new ElementParserException("PrimParser can not handle elements with the name=" + elementName);
        }
        try {
            klass = ClassFactory.getKlass(elementName);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("ClassFactory could NOT load Class with type=" + elementName, ex);
        }
        String strValue = element.getAttribute("value");
        if (strValue == null) {
            throw new ElementParserException("definition of argument NOT correct (value must NOT be null)");
        }
        try {
            value = PrimObjectFactory.getWrapper(elementName, strValue);
        }
        catch (ConstructionException ex) {
            throw new ElementParserException(ex);
        }
        return new ClassObjectPair(klass, value);
    }

    static {
        HashSet<String> names = new HashSet<String>();
        names.add("string");
        names.add("int");
        names.add("long");
        names.add("short");
        names.add("float");
        names.add("double");
        names.add("boolean");
        names.add("char");
        ALLOWED_ELEMENT_NAMES = Collections.unmodifiableSet(names);
    }
}

