/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Element {
    @Nonnull
    private org.w3c.dom.Element nestedElement;

    public Element(@Nonnull org.w3c.dom.Element nestedElement) {
        this.nestedElement = nestedElement;
    }

    @Nonnull
    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        NamedNodeMap nnm = this.nestedElement.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node node = nnm.item(i);
            result.put(node.getNodeName(), node.getNodeValue());
        }
        return result;
    }

    @Nullable
    public String getAttribute(@Nonnull String name) {
        if (!this.nestedElement.hasAttribute(name)) {
            return null;
        }
        return this.nestedElement.getAttribute(name);
    }

    public String getAttributeValue(@Nonnull String name) {
        if (!this.nestedElement.hasAttribute(name)) {
            return null;
        }
        return this.nestedElement.getAttribute(name);
    }

    @Nonnull
    public List<Element> getElementsByTagName(@Nonnull String name) {
        NodeList nodeList = this.nestedElement.getElementsByTagName(name).item(0).getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add(new Element((org.w3c.dom.Element)nodeList.item(i)));
        }
        return result;
    }

    @Nonnull
    public String getNodeName() {
        return this.nestedElement.getNodeName();
    }

    @Nonnull
    public String getName() {
        return this.nestedElement.getNodeName();
    }

    @Nonnull
    public List<Element> getChildElements() {
        NodeList nodeList = this.nestedElement.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof org.w3c.dom.Element)) continue;
            result.add(new Element((org.w3c.dom.Element)nodeList.item(i)));
        }
        return result;
    }

    @Nonnull
    public List<Element> getChildren() {
        NodeList nodeList = this.nestedElement.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof org.w3c.dom.Element)) continue;
            result.add(new Element((org.w3c.dom.Element)nodeList.item(i)));
        }
        return result;
    }

    @Nullable
    public Element getParent() {
        return new Element((org.w3c.dom.Element)this.nestedElement.getParentNode());
    }
}

