/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.lib.resource.construct.xml.ClassFactory;
import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Construct;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ConstructParser
implements ElementParser {
    @Override
    @Nonnull
    public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
        ClassObjectPair retVal;
        Class klass;
        String className = element.getAttribute("class");
        if (className == null || className.isEmpty()) {
            throw new ElementParserException("attribute 'class' may not be null on " + element.getNodeName());
        }
        try {
            klass = ClassFactory.getKlass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("classLoader could NOT load class for name=" + className, ex);
        }
        List<Element> argChildren = element.getChildElements();
        ArrayList<Class> argClasses = new ArrayList<Class>(argChildren.size());
        ArrayList<Object> initArgs = new ArrayList<Object>(argChildren.size());
        for (Element el : argChildren) {
            try {
                ClassObjectPair cop = factory.getParser(el.getNodeName()).parse(el, factory);
                argClasses.add(cop.getKlass());
                initArgs.add(cop.getObject());
            }
            catch (ParserNotRegisteredException ex) {
                throw new ElementParserException("no parser found for element name=" + el.getNodeName(), ex);
            }
        }
        Construct construct = new Construct(klass, argClasses.toArray(new Class[argClasses.size()]), initArgs.toArray(new Object[initArgs.size()]));
        try {
            retVal = new ClassObjectPair(construct.getKlass(), construct.getObject());
        }
        catch (ConstructionException ex) {
            throw new ElementParserException(ex);
        }
        return retVal;
    }
}

