/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassFactory;
import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import java.util.List;
import javax.annotation.Nonnull;

public class CastParser
implements ElementParser {
    @Override
    @Nonnull
    public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
        ClassObjectPair retVal;
        String elementName = element.getNodeName();
        if (!elementName.equals("cast")) {
            throw new ElementParserException("cast-parser can not handle elements with the name=" + elementName);
        }
        String className = element.getAttribute("class");
        if (className == null || className.isEmpty()) {
            throw new ElementParserException("attribute 'class' may not be null or empty on element " + element.getNodeName());
        }
        List<Element> children = element.getChildElements();
        if (children.size() != 1) {
            throw new ElementParserException("a cast-tag must have exactly ONE child");
        }
        Element child = children.get(0);
        try {
            ClassObjectPair cop = factory.getParser(child.getNodeName()).parse(child, factory);
            Class klass = ClassFactory.getKlass(className);
            retVal = new ClassObjectPair(klass, cop.getObject());
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("could not find class for name=" + className, ex);
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException("could not find a parser for cast-child", ex);
        }
        return retVal;
    }
}

