/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.widgets;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.parts.DebugPart;
import ch.dvbern.tax.common.presentation.cd.parts.HelpPart;
import ch.dvbern.tax.common.presentation.cd.parts.MessagePart;
import ch.dvbern.tax.common.presentation.cd.parts.TranslationPart;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.widgets.Composite;

public abstract class TaxmeCompositeManager {
    private boolean setupDone = false;
    protected Composite navigationPart;
    protected Composite contentPart;
    protected MessagePart messagePart;
    protected HelpPart helpPart;
    protected TranslationPart translationPart;
    protected DebugPart debugPart;

    public void setupContent(@NonNull Composite parent) {
        if (parent == null) {
            throw new NullPointerException("Parent composite cannot be null.");
        }
        if (this.setupDone) {
            this.disposeComposites();
        }
        this.setupContentInternal(parent);
        this.setupDone = true;
    }

    protected abstract void setupContentInternal(@NonNull Composite var1);

    public boolean isSetupDone() {
        return this.setupDone;
    }

    protected void checkSetupDone() {
        if (!this.setupDone) {
            throw new IllegalStateException("Setup not perfomed yet.");
        }
    }

    public @Nullable Composite getNavigationPart() {
        return this.navigationPart;
    }

    public @Nullable Composite getContentPart() {
        return this.contentPart;
    }

    public @Nullable MessagePart getMessagePart() {
        return this.messagePart;
    }

    public @Nullable HelpPart getHelpPart() {
        return this.helpPart;
    }

    public @Nullable TranslationPart getTranslationPart() {
        return this.translationPart;
    }

    public abstract void setExtraPanelVisible(boolean var1);

    public abstract void bringHelpPart();

    public abstract void bringMessagePart();

    public abstract void bringDebugPart();

    public void disposeComposites() {
        if (!this.setupDone) {
            return;
        }
        this.disposeCompositesInternal();
        this.navigationPart = null;
        this.contentPart = null;
        this.messagePart = null;
        this.helpPart = null;
        this.translationPart = null;
        this.debugPart = null;
        this.setupDone = false;
    }

    protected abstract void disposeCompositesInternal();

    public abstract void resizeToDefault();

    public abstract void saveConfiguration();

    public boolean isShortHelpEnabled() {
        return TaxmeConfig.getBoolean("IsShortHelpEnabled", true);
    }
}

