/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.MessageControlMapper;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePart
extends TaxmeComposite {
    private static final Logger LOG = LoggerFactory.getLogger(MessagePart.class);
    private ScrolledComposite scrollPanel;

    public MessagePart(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new FillLayout());
    }

    public void setContent(Collection<MessageItemDTO> msgs) {
        if (this.scrollPanel != null) {
            this.scrollPanel.dispose();
        }
        this.scrollPanel = new ScrolledComposite((Composite)this, 512);
        this.scrollPanel.setExpandVertical(true);
        this.scrollPanel.setExpandHorizontal(true);
        final Composite msgPanel = new Composite((Composite)this.scrollPanel, 0);
        this.scrollPanel.setContent((Control)msgPanel);
        msgPanel.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        msgPanel.setLayout((Layout)new GridLayout(1, false));
        for (MessageItemDTO msg : msgs) {
            Composite rowPanel = new Composite(msgPanel, 0);
            rowPanel.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
            rowPanel.setLayout((Layout)new GridLayout(2, false));
            MsgEntry entry = new MsgEntry(rowPanel, msg);
            MouseListener listener = new MouseListener(){

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                }

                public void mouseDown(MouseEvent mouseEvent) {
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    Control panel = (Control)mouseEvent.getSource();
                    MsgEntry entry = (MsgEntry)panel.getData();
                    MessagePart.this.setColor(msgPanel, GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
                    MessagePart.this.setColor(entry.rowPanel, GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT));
                    Control ctrl = MessageControlMapper.getInstance().get(entry.msgItem);
                    if (ctrl != null) {
                        ctrl.setFocus();
                    }
                }
            };
            rowPanel.addMouseListener(listener);
            rowPanel.setData((Object)entry);
            Label iconLbl = new Label(rowPanel, 0);
            iconLbl.setImage(GuiUtil.createStateImage(msg.getType(), true));
            iconLbl.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            iconLbl.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 4).grab(false, true).create());
            iconLbl.setData((Object)entry);
            iconLbl.addMouseListener(listener);
            Label msgLbl = new Label(rowPanel, 64);
            msgLbl.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            msgLbl.setImage(GuiUtil.createStateImage(msg.getType(), true));
            msgLbl.setText(TaxmeController.getInstance().getLocalizationHelper().translate(msg.getKey(), new Object[]{msg.getValue()}));
            msgLbl.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
            msgLbl.setData((Object)entry);
            msgLbl.addMouseListener(listener);
        }
        this.setColor(msgPanel, GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        Point p = msgPanel.computeSize(-1, -1);
        this.scrollPanel.setMinSize(-1, p.y);
        this.scrollPanel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = MessagePart.this.scrollPanel.getClientArea();
                MessagePart.this.scrollPanel.setMinSize(msgPanel.computeSize(r.width, -1));
            }
        });
        this.layout();
    }

    private void setColor(Composite composite, Color color) {
        composite.setBackground(color);
        for (Control ctrl : composite.getChildren()) {
            if (ctrl instanceof Composite) {
                this.setColor((Composite)ctrl, color);
                continue;
            }
            ctrl.setBackground(color);
        }
    }

    private static class MsgEntry {
        final Composite rowPanel;
        final MessageItemDTO msgItem;

        MsgEntry(Composite rowPanel, MessageItemDTO msgItem) {
            assert (rowPanel != null && msgItem != null);
            this.rowPanel = rowPanel;
            this.msgItem = msgItem;
        }
    }
}

