/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.help.util.EditableHelpMapping;
import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpPart
extends TaxmeComposite {
    private static final Logger LOG = LoggerFactory.getLogger(HelpPart.class);
    private Browser browser = null;
    private String currentHelpUrl;

    public HelpPart(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new FillLayout());
        try {
            this.browser = BrowserUtil.createBrowser(this);
            this.show("kurzhilfeDefault.html");
        }
        catch (BrowserNotSupportedException e) {
            LOG.error("Error creating browser for help part: ", (Throwable)e);
            this.browser = null;
        }
    }

    public void setContent(String key) {
        assert (key != null);
        this.setContent(key, null);
    }

    public void setContent(String key, String fallbackKey) {
        String helpPath;
        assert (key != null);
        EditableHelpMapping shortHelpMapping = TaxmeController.getInstance().getShortHelpMapping();
        if (fallbackKey == null) {
            helpPath = shortHelpMapping.resolve(key);
        } else {
            helpPath = shortHelpMapping.get(key);
            if (helpPath == null) {
                helpPath = shortHelpMapping.resolve(fallbackKey);
            }
        }
        assert (helpPath != null);
        this.show(helpPath);
    }

    private void show(String helpPath) {
        assert (helpPath != null);
        String url = TaxmeConfig.getShorthelpFilePath(helpPath);
        if (!url.equals(this.currentHelpUrl)) {
            this.currentHelpUrl = url;
            if (this.browser != null) {
                this.browser.setUrl(this.currentHelpUrl);
            }
        }
    }

    public String getHtmlUrl() {
        return this.currentHelpUrl;
    }

    public void refresh() {
        if (this.browser != null) {
            this.browser.refresh();
        }
    }
}

