/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.ButtonAddAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonDeleteAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonEditAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonVisualizeAction;
import ch.dvbern.tax.common.presentation.cd.parts.ButtonsPart;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeButton;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CreateTableButtonAreaPart
extends ButtonsPart {
    private final TaxmeButton addButton;
    private final TaxmeButton editButton;
    private final TaxmeButton deleteButton;
    private final TaxmeButton visualizeButton;
    private final boolean onlyShowVisualizeButton;
    private final boolean customButtonsEnabled = TaxmeConfig.getBoolean("table.buttons.custom", false);
    private final boolean isMac = OsSupport.isMacOs();

    public CreateTableButtonAreaPart(Composite parent, boolean onlyShowVisualizeButton) {
        super(parent);
        this.setLayout((Layout)new GridLayout(3, true));
        this.onlyShowVisualizeButton = onlyShowVisualizeButton;
        ButtonAddAction buttonAddAction = (ButtonAddAction)ActionRegistry.getInstance().getAction("table.add");
        this.addButton = this.createButton(buttonAddAction);
        ButtonEditAction buttonEditAction = (ButtonEditAction)ActionRegistry.getInstance().getAction("table.edit");
        this.editButton = this.createButton(buttonEditAction);
        ButtonDeleteAction buttonDeleteAction = (ButtonDeleteAction)ActionRegistry.getInstance().getAction("table.delete");
        this.deleteButton = this.createButton(buttonDeleteAction);
        ButtonVisualizeAction buttonVisualizeAction = (ButtonVisualizeAction)ActionRegistry.getInstance().getAction("table.visualize");
        this.visualizeButton = this.createButton(buttonVisualizeAction);
        if (this.isMac && this.customButtonsEnabled) {
            this.addMacDarkStyle(this.addButton);
            this.addMacDarkStyle(this.editButton);
            this.addMacDarkStyle(this.deleteButton);
            this.addMacDarkStyle(this.visualizeButton);
        }
    }

    private void addMacDarkStyle(final TaxmeButton button) {
        button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                button.setBackground(CreateTableButtonAreaPart.this.getDisplay().getSystemColor(15));
                button.setForeground(CreateTableButtonAreaPart.this.getDisplay().getSystemColor(2));
            }
        });
    }

    public void init(TableViewer tableViewer) {
        if (!this.onlyShowVisualizeButton) {
            this.addButton.setData(tableViewer);
            this.addButton.setEnabled(true);
            this.editButton.setData(tableViewer);
            this.editButton.setEnabled(false);
            this.deleteButton.setData(tableViewer);
            this.deleteButton.setEnabled(false);
            this.visualizeButton.setData(tableViewer);
            this.visualizeButton.setVisible(false);
            this.visualizeButton.setEnabled(false);
        } else {
            this.visualizeButton.setData(tableViewer);
            this.visualizeButton.setEnabled(false);
            this.addButton.setVisible(false);
            this.addButton.setEnabled(false);
            this.deleteButton.setVisible(false);
            this.deleteButton.setEnabled(false);
            this.editButton.setVisible(false);
            this.editButton.setEnabled(false);
        }
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent ev) {
                CreateTableButtonAreaPart.this.editButton.setEnabled(!ev.getSelection().isEmpty());
                CreateTableButtonAreaPart.this.visualizeButton.setEnabled(!ev.getSelection().isEmpty());
                CreateTableButtonAreaPart.this.deleteButton.setEnabled(!ev.getSelection().isEmpty());
            }
        });
    }
}

