/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.listeners;

import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.FileHistory;
import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class CloseListener
implements Listener {
    private FileHistory fileHistory;
    private Taxme taxme;
    private Shell shell;
    private DvbTaxCdSession tmoSession;

    public CloseListener(FileHistory fileHistory, Taxme taxme, Shell shell, DvbTaxCdSession tmoSession) {
        this.fileHistory = fileHistory;
        this.taxme = taxme;
        this.shell = shell;
        this.tmoSession = tmoSession;
    }

    private void saveFileHistory() {
        int i = 0;
        Iterator<File> it = this.fileHistory.entries();
        while (it.hasNext()) {
            File file = it.next();
            TaxmeConfig.setValue("file." + i + ".path", file.getAbsolutePath());
            ++i;
        }
    }

    public void handleEvent(Event ev) {
        if (!TaxmeController.getInstance().askForSave()) {
            ev.doit = false;
            return;
        }
        this.taxme.saveConfiguration();
        Objects.requireNonNull(this.shell).dispose();
        this.saveFileHistory();
        TaxmeConfig.setValue("view.mode", TaxmeController.getInstance().getMode().getId());
        File currentFile = this.tmoSession.getFile();
        if (currentFile != null) {
            TaxmeConfig.setValue("lastfile.path", currentFile.getAbsolutePath());
        } else {
            TaxmeConfig.remove("lastfile.path");
        }
        TaxmeConfig.store();
        this.tmoSession.removeUndoRedoStateListener(this.taxme);
    }
}

