/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.wizard;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.wizard.AWizardItem;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WValueItem
extends AWizardItem
implements IValueItem {
    private static final Logger LOG = LoggerFactory.getLogger(WValueItem.class);
    private final WizardDisplayInfoDTO.ItemItemDTO item;
    private int style;
    private final boolean tableItem;

    public WValueItem(WizardDisplayInfoDTO.ItemItemDTO item, boolean tableItem) {
        this.item = item;
        this.tableItem = tableItem;
        this.style = 0;
        if (item.getReadonly()) {
            this.style = 1;
        } else if (item.getState() >= 11) {
            this.style = 2;
        }
    }

    @Override
    public @Nullable Object getValue() {
        return this.item.getValue();
    }

    @Override
    public String getRenderedValue() {
        return WValueItem.render(this.item);
    }

    @Override
    public AbstractConverter<?> getRendererAndInputValidator() {
        return this.item.getRendererAndInputValidator();
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public int getColspan() {
        return this.item.getColspan();
    }

    @Override
    public int getRowspan() {
        return this.item.getRowspan();
    }

    @Override
    public String getAlign() {
        return this.item.getAlign();
    }

    @Override
    public int getMaxLength() {
        return this.item.getMaxlength();
    }

    @Override
    public @Nullable String getRegularExpression() {
        if (this.item.getRendererAndInputValidator() != null) {
            return this.item.getRendererAndInputValidator().getUserInputRegExpPattern();
        }
        return null;
    }

    @Override
    public int calcLength(String input) {
        if (this.item.getRendererAndInputValidator() != null) {
            return this.item.getRendererAndInputValidator().calcLength(input);
        }
        return input == null ? 0 : input.length();
    }

    @Override
    public boolean isValidateIfLeftEmpty() {
        return this.item.isValidateIfLeftEmpty();
    }

    @Override
    public int getState() {
        return this.item.getState();
    }

    @Override
    public @Nullable OptionItemsDTO getOptionItems() {
        return this.item.getOptionItems();
    }

    @Override
    public void setDefaultValue(String value) {
        AbstractConverter conv = this.item.getRendererAndInputValidator();
        if (conv != null) {
            try {
                TaxmeController ctrl = TaxmeController.getInstance();
                AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), this.item.getDataModelKey());
                Object convertedValue = conv.getObject(value, this.item.getOptionItems(), ctx);
                this.item.setValue(convertedValue);
            }
            catch (AbstractConverter.ConvertException e) {
                LOG.error("Error setting defaul value: ", (Throwable)e);
            }
        } else {
            this.item.setValue((Object)value);
        }
    }

    @Override
    public @NonNull DisplayItemUniqueID getUID() {
        return this.item.getUniqueItemIdentifier();
    }

    @Override
    public int getType() {
        return this.item.getType();
    }

    @Override
    public Color getForegroundColor() {
        if (this.item.getForegroundColor() != null) {
            return GuiUtil.getColorRegistry().get(this.item.getForegroundColor());
        }
        switch (this.getStyle()) {
            case 1: {
                if (this.tableItem) {
                    return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_FOREGROUND_READONLY);
                }
                return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_FOREGROUND_READONLY);
            }
            case 2: {
                if (this.tableItem) {
                    return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_FOREGROUND_TRANSPARENT);
                }
                return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_FOREGROUND_TRANSPARENT);
            }
        }
        if (this.tableItem) {
            return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_FOREGROUND);
        }
        return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_FOREGROUND);
    }

    @Override
    public Color getBackgroundColor() {
        switch (this.getStyle()) {
            case 1: {
                if (this.tableItem) {
                    return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_BACKGROUND_READONLY);
                }
                return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_BACKGROUND_READONLY);
            }
            case 2: {
                if (this.tableItem) {
                    return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_TABLE_CELL_BACKGROUND_TRANSPARENT);
                }
                return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_BACKGROUND_TRANSPARENT);
            }
        }
        switch (this.item.getState()) {
            case 4: {
                return RED;
            }
            case 2: {
                return YELLOW;
            }
        }
        if (this.item.getType() == 3 || this.item.getType() == 1) {
            return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_LABEL_BACKGROUND);
        }
        return GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_INPUT_BACKGROUND);
    }

    @Override
    public Font getFont() {
        switch (this.getStyle()) {
            case 1: {
                if (this.tableItem) {
                    return GuiUtil.getFontRegistry().get("font.normal");
                }
                return GuiUtil.getFontRegistry().get("font.disabled");
            }
            case 2: {
                return GuiUtil.getFontRegistry().get("font.normal");
            }
        }
        return GuiUtil.getFontRegistry().get("font.normal");
    }

    @Override
    public void update(String newValue) {
        ValidateAction validateAction = new ValidateAction();
        validateAction.execute(newValue, this.item);
    }

    @Override
    public @Nullable Object getOptionValue() {
        return null;
    }

    @Override
    public Collection<MessageItemDTO> getMessages() {
        return this.item.getMessages();
    }

    @Override
    public boolean hasBorder() {
        return !this.tableItem || OsSupport.isLinuxOs() || OsSupport.isMacOs();
    }

    public WizardDisplayInfoDTO.ItemItemDTO getItem() {
        return this.item;
    }

    @Override
    public @Nullable String getShortHelpKey() {
        return this.item.getShortHelpKey();
    }

    @Override
    public boolean isDynamicWidth() {
        return false;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Item.Layout getLayout() {
        return this.item.getLayout();
    }
}

