/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertGuiUtil;
import ch.dvbern.tax.common.presentation.cd.items.IItem;
import ch.dvbern.tax.common.presentation.cd.items.common.AItem;
import ch.dvbern.tax.common.presentation.cd.util.OutputRenderer;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AExpertItem<IDTO extends ExpertDisplayInfoDTO.ItemDTO, CDTO extends ExpertDisplayInfoDTO.TableDTO.CellDTO>
extends AItem
implements IItem {
    private static final OutputRenderer RENDERER = new OutputRenderer();
    private final IDTO item;
    private final CDTO cell;
    private final float zoom;

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.item).append(this.cell).build();
    }

    protected AExpertItem(IDTO item, float zoom) {
        this.item = item;
        this.cell = null;
        this.zoom = zoom;
    }

    protected AExpertItem(CDTO cell, float zoom) {
        this.item = null;
        this.cell = cell;
        this.zoom = zoom;
    }

    @Override
    public int getRowspan() {
        return 0;
    }

    @Override
    public int getColspan() {
        return 0;
    }

    @Override
    public @Nullable Color getBackgroundColor() {
        if (this.item != null) {
            return this.getColor(this.item.getBgColor());
        }
        return null;
    }

    @Override
    public @Nullable Color getForegroundColor() {
        return null;
    }

    @Override
    public @NonNull DisplayItemUniqueID getUID() {
        if (this.item != null) {
            return this.item.getUniqueItemIdentifier();
        }
        if (this.cell != null) {
            return this.cell.getUniqueItemIdentifier();
        }
        throw new IllegalStateException("Either item or cell must be != null");
    }

    @Override
    public @Nullable Rectangle getBounds() {
        if (this.item == null) {
            return null;
        }
        int x = this.item.getX(this.zoom);
        int y = this.item.getY(this.zoom);
        int width = this.item.getWidth(this.zoom);
        int heigth = this.item.getHeight(this.zoom);
        return new Rectangle(x, y, width, heigth);
    }

    protected @Nullable Color getColor(ColorDTO color) {
        if (color == null) {
            return null;
        }
        return ExpertGuiUtil.getColor(color);
    }

    protected static String render(ExpertDisplayInfoDTO.ValueItemDTO item) {
        return RENDERER.render(item);
    }

    protected static String render(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cell) {
        return RENDERER.render(col, cell);
    }

    protected float getZoom() {
        return this.zoom;
    }

    protected IDTO getItemRef() {
        return this.item;
    }

    protected CDTO getCellRef() {
        return this.cell;
    }
}

