/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.expertdisplay;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.builders.ControlBuilderFactory;
import ch.dvbern.tax.common.presentation.cd.builders.ControlPanelHolder;
import ch.dvbern.tax.common.presentation.cd.builders.Director;
import ch.dvbern.tax.common.presentation.cd.builders.IControlBuilder;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpertFormDataPart
extends TaxmeComposite {
    private static final Logger LOG = LoggerFactory.getLogger(ExpertFormDataPart.class);
    private static final float ZOOM = 1.3865546f;
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private final ControlReuseUtil controlReuseUtil = new ControlReuseUtil();
    private List<Control> tabOrder;
    private Point bgSize;
    private final String formName;

    public ExpertFormDataPart(Composite parent, String formName) {
        super(parent, 0);
        this.formName = formName;
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        if (TaxmeController.isDevelopmentMode()) {
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent event) {
                    Point point0 = ExpertFormDataPart.this.getShell().toDisplay(0, 0);
                    Point pointMouse = ExpertFormDataPart.this.getShell().toDisplay(event.x, event.y);
                    Point location = new Point(pointMouse.x - point0.x, pointMouse.y - point0.y);
                    TaxmeController.getInstance().getDebugPart().setCursorLocation(location);
                }
            });
        }
    }

    private void addToTabOrder(List<? extends Control> controls) {
        if (controls != null) {
            this.tabOrder.addAll(controls);
        }
    }

    public boolean setFocus() {
        Control[] tabList = this.getTabList();
        if (tabList != null) {
            for (Control element : tabList) {
                if (!element.setFocus()) continue;
                return true;
            }
        }
        return false;
    }

    public void setContent(ExpertDisplayInfoDTO expertInfoDTO) {
        this.tabOrder = new ArrayList<Control>();
        this.controlReuseUtil.start();
        this.generateContent(expertInfoDTO);
        this.controlReuseUtil.end();
        this.setTabList(this.tabOrder.toArray(new Control[this.tabOrder.size()]));
    }

    private void generateContent(ExpertDisplayInfoDTO expertInfoDTO) {
        this.setBackground(expertInfoDTO.getGuiBackground());
        Director director = new Director();
        ControlBuilderFactory cbf = ControlBuilderFactory.getInstance();
        ControlPanelHolder panel = new ControlPanelHolder(this, this.controlReuseUtil, 1.3865546f);
        List items = expertInfoDTO.getItems();
        for (ExpertDisplayInfoDTO.ItemDTO itemDTO : items) {
            IControlBuilder builder = cbf.createBuilder(itemDTO);
            director.init(builder, panel);
            director.createControl();
            this.addToTabOrder(builder.getTabOrder());
        }
    }

    private void setBackground(ExpertDisplayInfoDTO.ImageDTO imageDTO) {
        Image img;
        boolean hasImage;
        String bgImage = imageDTO != null ? imageDTO.getFileName() : null;
        boolean bl = hasImage = bgImage != null && !bgImage.isEmpty();
        if (hasImage && this.getBackgroundImage() == null && (img = this.getImage(bgImage)) != null) {
            if (this.isMacOperatingSystem()) {
                this.setBackgroundImage(this.createTransparentImage(Display.getCurrent(), img));
            } else {
                this.setBackgroundImage(img);
            }
            this.setBackgroundMode(1);
            PaintListener paintListener = paintEvent -> this.paintBackgroundImage(paintEvent.gc, img);
            this.addPaintListener(paintListener);
            this.addDisposeListener(ignored -> this.removePaintListener(paintListener));
        }
    }

    private boolean isMacOperatingSystem() {
        String name = System.getProperty("os.name").toLowerCase();
        return name.startsWith("mac os");
    }

    private Image createTransparentImage(Display display, Image img) {
        Rectangle imgSize = img.getBounds();
        ImageData imData = new ImageData(imgSize.width, imgSize.height, 24, new PaletteData(0xFF0000, 65280, 255));
        imData.setAlpha(0, 0, 0);
        Arrays.fill(imData.alphaData, (byte)0);
        return new Image((Device)display, imData);
    }

    private void paintBackgroundImage(GC gc, Image img) {
        Rectangle imgSize = img.getBounds();
        this.setSize(imgSize.width, imgSize.height);
        this.bgSize = new Point(imgSize.width, imgSize.height);
        gc.drawImage(img, 0, 0);
    }

    private Image getImage(String name) {
        ImageSource is = TaxmeController.getInstance().getFormSource();
        return GuiUtil.getImage(is, name, imageRegistry);
    }

    public Point computeSize(int arg0, int arg1) {
        if (this.bgSize == null) {
            return super.computeSize(arg0, arg1);
        }
        return this.bgSize;
    }

    public float getZoom() {
        return 1.3865546f;
    }

    public String getFormName() {
        return this.formName;
    }
}

