/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.expertdisplay;

import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertFormDataPart;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertMultiFormIndexPart;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ExpertContentPart
extends ScrolledComposite {
    private ExpertFormDataPart formData;
    private ExpertMultiFormIndexPart tableIndex;
    private String currentForm;

    public ExpertContentPart(Composite parent) {
        super(parent, 2816);
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        this.setLayout((Layout)new FillLayout());
        this.getVerticalBar().setIncrement(10);
    }

    public void setContent(ExpertDisplayInfoDTO expertInfoDTO) {
        this.setRedraw(false);
        if (expertInfoDTO.getItems() == null || expertInfoDTO.getItems().isEmpty()) {
            if (this.formData != null) {
                this.formData.dispose();
                this.formData = null;
            }
            if (this.currentForm != null) {
                this.currentForm = null;
            }
            this.setIndexContent(expertInfoDTO);
        } else {
            if (this.tableIndex != null) {
                this.tableIndex.dispose();
                this.tableIndex = null;
            }
            this.setDataContent(expertInfoDTO);
        }
    }

    private void setIndexContent(ExpertDisplayInfoDTO expertInfoDTO) {
        this.tableIndex = new ExpertMultiFormIndexPart((Composite)this);
        this.setContent((Control)this.tableIndex);
        this.tableIndex.setContent(expertInfoDTO);
        this.tableIndex.setSize(this.tableIndex.computeSize(-1, -1));
        this.setRedraw(true);
    }

    private void setDataContent(ExpertDisplayInfoDTO expertInfoDTO) {
        boolean reuse;
        boolean bl = reuse = this.currentForm != null && this.currentForm.equals(expertInfoDTO.getUniqueItemIdentifier());
        if (!reuse && this.formData != null) {
            this.formData.dispose();
            this.formData = null;
        }
        if (this.formData == null) {
            this.formData = new ExpertFormDataPart((Composite)this, expertInfoDTO.getName());
            this.setContent((Control)this.formData);
        }
        this.formData.setContent(expertInfoDTO);
        this.formData.setSize(this.formData.computeSize(-1, -1));
        this.currentForm = expertInfoDTO.getUniqueItemIdentifier();
        this.setRedraw(true);
        if (!reuse) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ExpertContentPart.this.formData != null && !ExpertContentPart.this.formData.isDisposed()) {
                        ExpertContentPart.this.formData.setFocus();
                    }
                }
            });
        }
    }
}

