/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action.menu;

import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.action.MixedPrintableAction;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintUtil;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfPrinterInput;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.printing.PrintEntry;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import java.io.File;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MixedFilePrintAction
extends ActionBase
implements ButtonCommand {
    private static final Logger LOG = LoggerFactory.getLogger(MixedFilePrintAction.class);

    public MixedFilePrintAction() {
        this("menu.file.print", "Ctrl+P", "icon.menu.file.print");
    }

    public MixedFilePrintAction(String name, String shortcut, String iconName) {
        super(name, shortcut, iconName);
    }

    public void run() {
        MixedPrintableAction printAction;
        TaxmeController ctrl = TaxmeController.getInstance();
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        if (ctrl.getMode() == Mode.EXPERT) {
            session.touchCompleteModel();
            ctrl.update();
        }
        if ((printAction = this.buildMixedPrintableAction()) == null) {
            return;
        }
        boolean anyEnabled = printAction.getPrintEntries().stream().anyMatch(PrintEntry::isFormularEnabled);
        if (!anyEnabled) {
            DialogUtil.showErrorDialog("message.printint.keine-formulare-ausgewaehlt", new Object[0]);
            return;
        }
        List<PrintEntry> printEntries = printAction.getPrintEntries();
        PdfPrinterInput input = this.buildPdfPrinterInput(session, ctrl.getLocalizationHelper(), new FormRendererConfiguration());
        LocalizationHelper localizationHelper = ctrl.getLocalizationHelper();
        FormRendererConfiguration rendererConfiguration = printAction.getRendererConfiguration();
        File targetDirectory = TaxmeConfig.getPdfOutputDir();
        try {
            File pdfFile = PrintUtil.printMixed((DvbTaxSession)session, (PdfPrinterInput)input, printEntries, (ImageSource)session.getImageSource(), (LocalizationHelper)localizationHelper, (FormRendererConfiguration)rendererConfiguration, (File)targetDirectory);
            if (!LaunchUtil.launchPdfReader(pdfFile.getAbsolutePath())) {
                DialogUtil.showErrorDialog("message.acroread.failed", new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.error("Error printing", (Throwable)e);
            DialogUtil.showWarningDialog("message.printing.error", new Object[0]);
        }
    }

    protected abstract @NonNull PdfPrinterInput buildPdfPrinterInput(@NonNull DvbTaxSession var1, @NonNull LocalizationHelper var2, @NonNull FormRendererConfiguration var3);

    protected abstract @Nullable MixedPrintableAction buildMixedPrintableAction();

    @Override
    public void init(IButtonItem buttonDTO) {
    }

    @Override
    public void execute(IButtonItem buttonDTO) {
        this.run();
    }
}

