/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action;

import ch.dvbern.lib.pdfforms.PdfFormFiller;
import ch.dvbern.lib.pdfforms.pagenumbering.NOPPageNumberingAlgo;
import ch.dvbern.lib.pdfforms.pagenumbering.PageNumberingAlgo;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.action.MixedPrintableAction;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintUtil;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.DvbTaxPdfFormPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfPrinterInput;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.CheckboxResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.DataModelResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.IgnoreResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.LabelResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.NestedTableResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.SelectListCheckboxResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.YearResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.ZpvNummerResolver;
import ch.dvbern.tax.common.printing.PrintEntry;
import ch.dvbern.tax.common.transfer.failure.NotYetImplementedException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedFilePrintFormAction
extends ActionBase
implements ButtonCommand {
    private static final Logger LOG = LoggerFactory.getLogger(MixedFilePrintFormAction.class);

    public MixedFilePrintFormAction() {
        this("menu.file.print", "Ctrl+P", "icon.menu.file.print");
    }

    protected MixedFilePrintFormAction(String name, String shortcut, String iconName) {
        super(name, shortcut, iconName);
    }

    @Override
    public void init(IButtonItem buttonDTO) {
    }

    @Override
    public void execute(IButtonItem buttonDTO) {
        this.run();
    }

    public void run() {
        TaxmeController ctrl = TaxmeController.getInstance();
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        @NonNull MixedPrintableAction printAction = this.getPrintAction();
        List allForms = printAction.getPrintEntries().stream().filter(e -> e.getPageList() != null).flatMap(e -> e.getPageList().stream()).collect(Collectors.toList());
        List formKeys = printAction.getPrintEntries().stream().filter(e -> e.getFormKey() != null).map(PrintEntry::getFormKey).collect(Collectors.toList());
        DvbTaxPdfFormPrinter printer = new DvbTaxPdfFormPrinter();
        @NonNull PdfPrinterInput input = new PdfPrinterInput(Objects.requireNonNull(session.getDataModel()), session.getLogicModel(), allForms, ctrl.getLocalizationHelper(), (PageNumberingAlgo)new NOPPageNumberingAlgo(), Arrays.asList(new LabelResolver(), new ZpvNummerResolver(), new YearResolver(), new CheckboxResolver.CheckboxTrueResolver(), new CheckboxResolver.CheckboxFalseResolver(), new SelectListCheckboxResolver(), new SelectListCheckboxResolver("select-zivilstand", "X", "").withEntryMapping((Object)"6", (Object)"2").withEntryMapping((Object)"9", (Object)"5").withEntryMapping((Object)"8", (Object)"4").withEntryMapping((Object)"7", (Object)"3"), new IgnoreResolver("pagenum"), new NestedTableResolver(), new DataModelResolver(DataModelResolver.Localization.LOCALIZED_TEXT)), new FormRendererConfiguration().withCopyWatermark(true));
        MultiValuedMap pages = null;
        try {
            pages = printer.createPages(input);
        }
        catch (Exception e2) {
            LOG.error("Error printing", (Throwable)e2);
            DialogUtil.showWarningDialog("message.printing.error", new Object[0]);
            return;
        }
        try {
            List pageList = PrintUtil.flattenPagesSorted((MultiValuedMap)pages);
            byte[] pdfBytes = new PdfFormFiller().createPDF((Collection)pageList, true);
            if (pdfBytes == null) {
                DialogUtil.showErrorDialog("message.printint.keine-formulare-ausgewaehlt", new Object[0]);
                return;
            }
            File pdfOutputDir = TaxmeConfig.getPdfOutputDir();
            File pdfFile = File.createTempFile("tax_", ".pdf", pdfOutputDir);
            try (ByteArrayInputStream pdfIn = new ByteArrayInputStream(pdfBytes);
                 BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(pdfFile));){
                IOUtils.copyLarge((InputStream)pdfIn, (OutputStream)fileOut);
            }
            if (!LaunchUtil.launchPdfReader(pdfFile.getAbsolutePath())) {
                DialogUtil.showErrorDialog("message.acroread.failed", new Object[0]);
            }
        }
        catch (Exception e3) {
            throw new IllegalStateException("FIXME: should not see me", e3);
        }
    }

    public @NonNull MixedPrintableAction getPrintAction() {
        throw new NotYetImplementedException("Please implement this in a subclass");
    }
}

