/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.bd.cd.CDAuthenticationData;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.GuiEditorEntry;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeLauncher;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeInputDialog;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertContentPart;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertNavigationPart;
import ch.dvbern.tax.common.presentation.cd.help.parser.HelpParser;
import ch.dvbern.tax.common.presentation.cd.help.util.EditableHelpMapping;
import ch.dvbern.tax.common.presentation.cd.listeners.CloseListener;
import ch.dvbern.tax.common.presentation.cd.listeners.CloseListenerFactory;
import ch.dvbern.tax.common.presentation.cd.parts.DebugPart;
import ch.dvbern.tax.common.presentation.cd.parts.HelpPart;
import ch.dvbern.tax.common.presentation.cd.parts.MessagePart;
import ch.dvbern.tax.common.presentation.cd.parts.TranslationPart;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.FileHistory;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.MessageControlMapper;
import ch.dvbern.tax.common.presentation.cd.util.OpenException;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeCompositeManager;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardContentPart;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardNavigationPart;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.imports.ImportUtil;
import ch.dvbern.tax.common.presentation.common.util.FileImageSource;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import ch.dvbern.tax.common.transfer.failure.TaxFileCorruptedException;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxmeController {
    private static final Logger LOG = LoggerFactory.getLogger(TaxmeController.class);
    private static TaxmeController instance = null;
    private String wizardLinkDmk = null;
    private Taxme taxme = null;
    private DvbTaxCdSession tmoSession = null;
    private String dataModelKey = null;
    private String formAccessKey = null;
    private final FileHistory fileHistory = new FileHistory(TaxmeConfig.getInt("file.history.size"));
    private final EditableHelpMapping shortHelpMapping = TaxmeController.retrieveShortHelpMapping();
    private ImageSource imageSource = null;
    private ImageSource iconSource = null;
    private WizardDisplayInfoDTO currentWizardDTO = null;
    private ExpertDisplayInfoDTO currentExpertDTO = null;
    private Mode mode = null;
    private @NonNull Locale currentLocale = Locale.GERMAN;
    private boolean declarationOpen = false;
    private static final String LANGUAGE = "language";
    private HashMap<DisplayItemUniqueID, GuiEditorEntry> guiEdits = null;
    private DebugPart debugPart = null;
    private ImportUtil importUtil = null;
    private boolean modelReload = false;
    private boolean isTempTaxfileEnabled = ApplicationConfig.getInstance().isTempTaxfileEnabled();

    public TaxmeController() {
        this.setupLocale();
    }

    private void setupLocale() {
        String lang = TaxmeConfig.getString(LANGUAGE);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
            lang = "fr".equalsIgnoreCase(lang) ? "fr" : "de";
            TaxmeConfig.setValue(LANGUAGE, lang);
        }
        this.currentLocale = new Locale(lang, "CH");
    }

    public static synchronized TaxmeController getInstance() {
        if (instance == null) {
            instance = new TaxmeController();
        }
        return instance;
    }

    public static synchronized void setInstance(@NonNull TaxmeController instance) {
        TaxmeController.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditableHelpMapping retrieveShortHelpMapping() {
        EditableHelpMapping helpMapping;
        String helpMappingLocation = TaxmeConfig.getShortHelpMappingFilePath();
        boolean fallbackOnParent = ApplicationConfig.getInstance().getBoolean("helpMappings.cd.fallbackOnParent", false);
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(helpMappingLocation));
            helpMapping = EditableHelpMapping.load(bis, fallbackOnParent);
        }
        catch (IOException e) {
            try {
                LOG.error("Failed to retrieve help mappings located under {}, assume empty", (Object)helpMappingLocation, (Object)e);
                helpMapping = EditableHelpMapping.loadEmpty(fallbackOnParent);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bis);
        }
        IOUtils.closeQuietly((InputStream)bis);
        return helpMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeHelpMapping() {
        String helpMappingLocation = TaxmeConfig.getShortHelpMappingFilePath();
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(helpMappingLocation));
            this.shortHelpMapping.store(bos);
        }
        catch (IOException e) {
            try {
                LOG.error("Failled to persist help mappings under {}, assume empty", (Object)helpMappingLocation, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)bos);
        }
        IOUtils.closeQuietly((OutputStream)bos);
    }

    public void openFile(File file, boolean force) {
        this.openFile(file, null, force);
    }

    public void importFile(File file, boolean force) {
        this.openFile(null, file, force);
    }

    private void checkFileVersionToOpen() throws InvalidAuthenticationException, IOException, OpenException {
        Map newModel = this.tmoSession.getTaxFile().readModel();
        if (!TaxFileConfig.getInstance().checkVersion(newModel)) {
            throw new RuntimeException("DataModel version check failed.");
        }
    }

    public void openFile(File file, File importFrom, boolean force) {
        int rc;
        TaxmeInputDialog dlg;
        if (!force && !this.askForSave()) {
            return;
        }
        if (this.declarationOpen) {
            this.tmoSession.logout();
        }
        if (this.isTempTaxfileEnabled && file != null) {
            try {
                File localFile = File.createTempFile(file.getName().replace(".tax", ""), ".tax");
                localFile.deleteOnExit();
                FileUtils.copyFile((File)file, (File)localFile);
                this.tmoSession.setSourceTaxFile(file);
                file = localFile;
            }
            catch (IOException e) {
                LOG.error("Cannot retrieve document store instance", (Throwable)e);
                DialogUtil.showErrorDialog(this.getShell(), "documents.action.error", new Object[0]);
            }
        }
        this.tmoSession.setFile(file);
        String password = "";
        boolean finished = false;
        while (!finished) {
            try {
                if (importFrom == null && file != null) {
                    this.checkFileVersionToOpen();
                }
                this.tmoSession.login(new CDAuthenticationData(password));
                if (!TaxFileConfig.getInstance().checkVersion(this.tmoSession.getDataModel())) {
                    throw new RuntimeException("DataModel version check failed.");
                }
                TaxmeController.writeLanguageToModel(this.tmoSession, this.getLanguage());
                finished = true;
                if (this.isTempTaxfileEnabled) {
                    this.fileHistory.addEntry(this.tmoSession.getSourceTaxfile());
                } else {
                    this.fileHistory.addEntry(file);
                }
                this.declarationOpen = true;
            }
            catch (InvalidAuthenticationException ignored) {
                dlg = new TaxmeInputDialog(this.getShell(), Messages.configurableTranslate("message.enterpassword", new Object[0]), Messages.configurableTranslate("label.password", new Object[0]), null, null);
                rc = dlg.open();
                if (rc == 0) {
                    password = dlg.getValue();
                    continue;
                }
                finished = true;
                this.declarationOpen = false;
            }
            catch (TaxFileCorruptedException tfre) {
                LOG.error("could not read file", (Throwable)tfre);
                DialogUtil.showErrorDialog("error.open.corrupt.file", new Object[0]);
                finished = true;
                this.declarationOpen = false;
            }
            catch (Exception e) {
                LOG.error("could not read file", (Throwable)e);
                DialogUtil.showErrorDialog(e, "error.open.unbekannt");
                finished = true;
                this.declarationOpen = false;
            }
        }
        if (this.declarationOpen && importFrom != null) {
            password = "";
            finished = false;
            while (!finished) {
                try {
                    this.getImportUtil().doImport((InputStream)new BufferedInputStream(new FileInputStream(importFrom)), (DvbTaxSession)this.tmoSession, password, false);
                    finished = true;
                }
                catch (InvalidAuthenticationException ignored) {
                    dlg = new TaxmeInputDialog(this.getShell(), Messages.configurableTranslate("message.enterpassword", new Object[0]), Messages.configurableTranslate("label.password", new Object[0]), null, null);
                    rc = dlg.open();
                    if (rc == 0) {
                        password = dlg.getValue();
                        continue;
                    }
                    finished = true;
                }
                catch (Exception e) {
                    finished = true;
                    LOG.error("Error importing {}, {}", new Object[]{file, importFrom, e});
                    DialogUtil.showErrorDialog(e, "error.import.unbekannt");
                    this.declarationOpen = false;
                }
            }
        }
        if (this.declarationOpen) {
            if (ActionRegistry.getInstance().getAction("init") != null) {
                ActionRegistry.getInstance().getAction("init").run();
            }
        } else {
            this.tmoSession.setFile(null);
        }
        this.setTitle();
        this.setStatusLine();
        this.dataModelKey = null;
        this.formAccessKey = null;
        this.wizardLinkDmk = null;
        if (this.mode == Mode.EXPERT && !this.isExpertModeEnabled()) {
            this.mode = Mode.WIZARD;
        }
        this.taxme.rebuild();
        this.taxme.undoRedoStateChanged(false, false);
        this.update(null, true);
        TaxmeController.updateViewmodusInModel();
    }

    public void setTitle() {
        this.setTitle("taxme.cd.title", new Object[0]);
    }

    public void setTitle(@NonNull String titleProperty, Object ... args) {
        File file;
        Object title = Messages.configurableTranslate(titleProperty, args);
        if (this.declarationOpen && (file = this.tmoSession.getFile()) != null) {
            title = (String)title + " - " + (this.isTempTaxfileEnabled ? this.tmoSession.getSourceTaxfile().getName() : file.getName());
        }
        Objects.requireNonNull(this.getShell()).setText((String)title);
    }

    private void setStatusLine() {
        Object value;
        ModelItemDTO modelItem;
        Object status = "";
        Map model = this.tmoSession.getDataModel();
        if (model != null && (modelItem = (ModelItemDTO)model.get("Stammdaten.Dossiertraeger.NameDossiertraeger")) != null && (value = modelItem.getValue()) != null) {
            status = Messages.configurableTranslate("label.ready", new Object[0]) + " " + value.toString();
        }
        this.getApp().setStatus((String)status);
    }

    public File closeFile() {
        if (!this.askForSave()) {
            return this.tmoSession.getFile();
        }
        File toReturn = this.tmoSession.getFile();
        this.tmoSession.logout();
        this.declarationOpen = false;
        this.setTitle();
        this.setStatusLine();
        this.taxme.rebuild();
        return toReturn;
    }

    public boolean saveFile() {
        boolean isSaved = false;
        if (this.tmoSession.getFile() == null) {
            isSaved = this.saveFileAs();
        } else {
            try {
                this.tmoSession.save();
            }
            catch (Exception e) {
                LOG.error("Error saving file", (Throwable)e);
                DialogUtil.showErrorDialog("error.save.unbekannt", new Object[0]);
            }
            isSaved = true;
        }
        if (this.isTempTaxfileEnabled && isSaved) {
            try {
                FileUtils.copyFile((File)this.tmoSession.getFile(), (File)this.tmoSession.getSourceTaxfile());
            }
            catch (IOException e) {
                LOG.error("Error copying local file back to original file", (Throwable)e);
                DialogUtil.showErrorDialog("error.save.unbekannt", new Object[0]);
            }
        }
        return isSaved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFileAs() {
        File newFile = this.showSaveDialog();
        if (newFile == null) {
            return false;
        }
        File oldFile = this.tmoSession.getFile();
        if (newFile.exists() && DialogUtil.showYesNoCancelDialog("warning.save.replace", new Object[0]) != 0) {
            return false;
        }
        try {
            if (oldFile != null && oldFile.exists() && !oldFile.equals(newFile)) {
                FileUtils.copyFile((File)oldFile, (File)newFile);
            }
            if (this.isTempTaxfileEnabled) {
                this.tmoSession.setSourceTaxFile(newFile);
                if (this.tmoSession.getFile() == null) {
                    Calendar cal = Calendar.getInstance();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                    File initialFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "temp" + sdf.format(Calendar.getInstance().getTime()) + ".tax");
                    this.tmoSession.setFile(initialFile);
                    this.tmoSession.save();
                    File localFile = File.createTempFile(newFile.getName().replace(".tax", ""), ".tax");
                    localFile.deleteOnExit();
                    FileUtils.copyFile((File)this.tmoSession.getFile(), (File)localFile);
                    this.tmoSession.setFile(localFile);
                    FileUtils.deleteQuietly((File)initialFile);
                } else {
                    this.tmoSession.save();
                }
            } else {
                this.tmoSession.setFile(newFile);
                this.tmoSession.save();
            }
            if (this.isTempTaxfileEnabled) {
                try {
                    FileUtils.copyFile((File)this.tmoSession.getFile(), (File)newFile);
                }
                catch (IOException e) {
                    LOG.error("Error copying local file back to original file", (Throwable)e);
                    DialogUtil.showErrorDialog("error.save.unbekannt", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            this.tmoSession.setFile(null);
            LOG.error("Error saving fileAs", (Throwable)e);
            DialogUtil.showErrorDialog("error.save.unbekannt", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setTitle();
            this.setStatusLine();
        }
        this.fileHistory.addEntry(newFile);
        return true;
    }

    private File showSaveDialog() {
        FileDialog dlg;
        Shell shell;
        if (TaxmeConfig.getBoolean("centerPopups")) {
            shell = new Shell(Display.getCurrent(), 65536);
            dlg = DialogUtil.createCenteredFileDialog(shell, 8192);
        } else {
            shell = this.getShell();
            dlg = new FileDialog(shell, 8192);
        }
        dlg.setText(Messages.translate("menu.file", new Object[0]));
        if (this.tmoSession.getFile() != null) {
            File oldFile = null;
            oldFile = !this.isTempTaxfileEnabled ? this.tmoSession.getFile() : this.tmoSession.getSourceTaxfile();
            File parent = oldFile.getParentFile();
            if (parent != null) {
                dlg.setFilterPath(parent.getAbsolutePath());
            }
            dlg.setFileName(oldFile.getName());
        } else {
            dlg.setFileName(this.getFilename());
            dlg.setFilterPath(TaxmeConfig.getSaveDir().getAbsolutePath());
        }
        String ext = TaxFileConfig.getInstance().getFileNameExtension();
        dlg.setFilterExtensions(new String[]{"*" + ext});
        Object fileName = dlg.open();
        if (TaxmeConfig.getBoolean("centerPopups")) {
            shell.dispose();
        }
        if (fileName == null) {
            return null;
        }
        if (((String)fileName).length() <= ext.length()) {
            fileName = (String)fileName + ext;
        }
        if (!((String)fileName).endsWith(ext)) {
            int start = ((String)fileName).length() - ext.length();
            String s = ((String)fileName).substring(start);
            if (s.equalsIgnoreCase(ext)) {
                StringBuilder sb = new StringBuilder((String)fileName);
                sb.replace(start, start + ext.length(), ext);
                fileName = sb.toString();
            } else {
                fileName = (String)fileName + ext;
            }
        }
        return new File((String)fileName);
    }

    private String getFilename() {
        return TaxFileConfig.getInstance().getFileName(this.tmoSession.getDataModel());
    }

    public boolean askForSave() {
        if (this.tmoSession.changesSaved()) {
            return true;
        }
        boolean saved = false;
        block4: while (!saved) {
            int rc = DialogUtil.showYesNoCancelDialog("message.asksave", new Object[0]);
            switch (rc) {
                case 0: {
                    saved = this.saveFile();
                    continue block4;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public Taxme getApp() {
        return this.taxme;
    }

    public DvbTaxCdSession getTmoCdSession() {
        return this.tmoSession;
    }

    public String getDataModelKey() {
        return this.dataModelKey;
    }

    public void setDataModelKey(String newDmk) {
        if (this.dataModelKey != null && this.dataModelKey.equals(newDmk)) {
            return;
        }
        this.update(newDmk, newDmk != null);
    }

    public void openWizardLink(String newDmk) {
        this.dataModelKey = newDmk;
        this.wizardLinkDmk = newDmk;
        this.setMode(Mode.WIZARD);
    }

    public void setFormAccessKey(String newFormAccessKey) {
        if (this.formAccessKey != null && this.formAccessKey.equals(newFormAccessKey)) {
            return;
        }
        this.formAccessKey = newFormAccessKey;
        this.currentExpertDTO = null;
        this.update();
    }

    public void setExpertDisplayInfo(ExpertDisplayInfoDTO currentExpertDTO, String fak) {
        this.currentExpertDTO = currentExpertDTO;
        this.formAccessKey = fak;
        this.refresh();
    }

    public String getFormAccessKey() {
        return this.formAccessKey;
    }

    public WizardDisplayInfoDTO getWizardDisplayInfoDTO() {
        if (this.currentWizardDTO == null) {
            this.currentWizardDTO = this.tmoSession.getWizardDisplayInfo();
        }
        return this.currentWizardDTO;
    }

    public boolean hasCurrentExpertFormNewMessages() {
        ExpertDisplayInfoDTO fiDTO;
        boolean result = false;
        HashSet<String> existingMessages = new HashSet<String>();
        if (this.currentExpertDTO != null && this.currentExpertDTO.getMessages() != null) {
            for (Object element : this.currentExpertDTO.getMessages()) {
                existingMessages.add(((MessageItemDTO)element).getKey());
            }
        }
        if ((fiDTO = Objects.requireNonNull(this.getExpertDisplayInfoDTO(this.formAccessKey, 1))).getMessages() != null) {
            Iterator i = fiDTO.getMessages().iterator();
            while (i.hasNext() && !result) {
                result = !existingMessages.contains(((MessageItemDTO)i.next()).getKey());
            }
        }
        if (result) {
            this.update();
        }
        return result;
    }

    public boolean hasCurrentWizardFormNewMessages() {
        boolean result = false;
        HashSet<String> existingMessages = new HashSet<String>();
        if (this.currentWizardDTO != null) {
            WizardDisplayInfoDTO.FormItemDTO formDTO = this.currentWizardDTO.getFormItemDTO();
            WizardDisplayInfoDTO.collectMessagesOnWizardDisplayForm((WizardDisplayInfoDTO.FormItemDTO)formDTO);
            for (MessageItemDTO msg : formDTO.getMessages()) {
                existingMessages.add(msg.getKey());
            }
        }
        WizardDisplayInfoDTO.FormItemDTO fiDTO = Objects.requireNonNull(this.getWizardDisplayInfoDTO(this.dataModelKey, false)).getFormItemDTO();
        WizardDisplayInfoDTO.collectMessagesOnWizardDisplayForm((WizardDisplayInfoDTO.FormItemDTO)fiDTO);
        Iterator i = fiDTO.getMessages().iterator();
        while (i.hasNext() && !result) {
            result = !existingMessages.contains(((MessageItemDTO)i.next()).getKey());
        }
        if (result) {
            this.update();
        }
        return result;
    }

    public WizardDisplayInfoDTO getWizardDisplayInfoDTO(String key, boolean autoEnable) {
        if (this.tmoSession == null) {
            return null;
        }
        return this.tmoSession.getWizardDisplayInfo(key, autoEnable);
    }

    public void setLocale(Locale locale) {
        if (locale.getLanguage().equals(this.currentLocale.getLanguage())) {
            return;
        }
        if (DialogUtil.showConfirmDialog("message.language.change", new Object[0])) {
            String language = locale.getLanguage();
            TaxmeConfig.setValue(LANGUAGE, language);
            TaxmeController.writeLanguageToModel(this.getTmoCdSession(), language);
            this.currentLocale = new Locale(language, "CH");
            this.restart();
        }
    }

    public void setUseLargeFonts(boolean useLargeFonts) {
        if (useLargeFonts == GuiUtil.isUseLargeFonts()) {
            return;
        }
        if (DialogUtil.showConfirmDialog("message.language.change", new Object[0])) {
            TaxmeConfig.setValue("fonts.large", useLargeFonts);
            this.restart();
        }
    }

    private void restart() {
        this.close();
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.taxme = null;
            TaxmeLauncher.setRestart(true);
        }
    }

    public boolean isUseLargeFonts() {
        return GuiUtil.isUseLargeFonts();
    }

    public String getLanguage() {
        return this.currentLocale.getLanguage();
    }

    public @NonNull Locale getLocale() {
        return this.currentLocale;
    }

    public ImageSource getImageSource() {
        if (this.tmoSession == null) {
            throw new IllegalStateException("May not get form image source because session is null");
        }
        return this.tmoSession.getImageSource();
    }

    public ImageSource getFormSource() {
        if (this.tmoSession == null) {
            throw new IllegalStateException("May not get form image source because session is null");
        }
        return this.tmoSession.getFormImageSource();
    }

    public ImageSource getIconSource() {
        if (this.iconSource == null) {
            this.iconSource = new FileImageSource(new File(TaxmeConfig.getIconDir()));
        }
        return this.iconSource;
    }

    public void createModelSnapshot() {
        this.getTmoCdSession().createModelSnapshot();
    }

    public void backtoModelSnapshot() {
        String newDMK = this.getTmoCdSession().backtoModelSnapshot();
        if (newDMK != null) {
            this.setDataModelKey(newDMK);
        }
    }

    public void update() {
        this.update(null, true);
    }

    public void update(boolean updateHelp) {
        this.update(null, updateHelp);
    }

    private void update(@Nullable String newDmk, boolean updateHelp) {
        if (this.mode == Mode.EXPERT) {
            assert (newDmk == null);
            this.currentExpertDTO = this.getExpertDisplayInfoDTO(this.formAccessKey, 1);
            this.currentWizardDTO = null;
            if (this.currentExpertDTO != null) {
                this.updateParts(updateHelp);
                this.formAccessKey = this.currentExpertDTO.getAccessKey();
            }
        } else {
            boolean navigationPerformed = false;
            if (newDmk != null) {
                try {
                    this.currentWizardDTO = this.getWizardDisplayInfoDTO(newDmk, this.isInWizardLink());
                    navigationPerformed = true;
                }
                catch (InvalidModelItemKeyException e) {
                    LOG.debug("Prevented navigation to form with unsuitable state.", (Throwable)e);
                }
            }
            if (!navigationPerformed) {
                this.currentWizardDTO = this.getWizardDisplayInfoDTO(this.dataModelKey, this.isInWizardLink());
            }
            this.currentExpertDTO = null;
            if (this.currentWizardDTO != null) {
                this.dataModelKey = this.currentWizardDTO.getThisKey();
                this.updateParts(updateHelp);
            }
        }
        this.taxme.setModeActionsState();
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean updateHelp) {
        if (this.mode == Mode.EXPERT) {
            this.currentWizardDTO = null;
            if (this.currentExpertDTO != null) {
                this.updateParts(updateHelp);
            }
        } else {
            this.currentExpertDTO = null;
            if (this.currentWizardDTO != null) {
                this.updateParts(updateHelp);
            }
        }
    }

    private void updateParts(boolean updateHelp) {
        HelpPart helpPart;
        String helpItem;
        Collection messages;
        TaxmeCompositeManager compositeManager = this.taxme.getCompositeManager();
        if (!compositeManager.isSetupDone()) {
            return;
        }
        if (this.mode == Mode.EXPERT) {
            this.currentExpertDTO.refreshMessages();
            messages = this.currentExpertDTO.getMessages();
            helpItem = this.currentExpertDTO.getName();
        } else {
            WizardDisplayInfoDTO.FormItemDTO formDTO = this.currentWizardDTO.getFormItemDTO();
            WizardDisplayInfoDTO.collectMessagesOnWizardDisplayForm((WizardDisplayInfoDTO.FormItemDTO)formDTO);
            messages = formDTO.getMessages();
            helpItem = formDTO.getName();
        }
        MessagePart messagePart = compositeManager.getMessagePart();
        if (messagePart != null) {
            messagePart.setContent(messages);
        }
        if ((helpPart = compositeManager.getHelpPart()) != null && updateHelp) {
            helpPart.setContent(helpItem);
        }
        MessageControlMapper.getInstance().reset();
        TranslationPart translationPart = compositeManager.getTranslationPart();
        if (translationPart != null) {
            translationPart.setContent(TranslationManager.getInstance().getTranslationMap());
        }
        if (TaxmeController.isDevelopmentMode()) {
            compositeManager.bringDebugPart();
        } else if (!messages.isEmpty()) {
            compositeManager.bringMessagePart();
        } else {
            compositeManager.bringHelpPart();
        }
        if (this.mode == Mode.EXPERT) {
            ExpertNavigationPart navPart = (ExpertNavigationPart)Objects.requireNonNull(compositeManager.getNavigationPart());
            ExpertContentPart contentPart = (ExpertContentPart)Objects.requireNonNull(compositeManager.getContentPart());
            navPart.setContent(this.currentExpertDTO);
            contentPart.setContent(this.currentExpertDTO);
        } else {
            WizardNavigationPart navPart = (WizardNavigationPart)Objects.requireNonNull(compositeManager.getNavigationPart());
            WizardContentPart contentPart = (WizardContentPart)Objects.requireNonNull(compositeManager.getContentPart());
            WizardDisplayInfoDTO.NavigationDTO navDTO = this.currentWizardDTO.getNavigationDTO();
            navPart.setContent(navDTO);
            contentPart.setContent(this.currentWizardDTO);
        }
    }

    public ExpertDisplayInfoDTO getExpertDisplayInfoDTO() {
        return this.currentExpertDTO;
    }

    public ExpertDisplayInfoDTO getExpertDisplayInfoDTO(String key, int mode) {
        if (this.tmoSession == null) {
            return null;
        }
        return this.tmoSession.getExpertDisplayInfo(key, this.currentLocale, mode);
    }

    private DvbTaxCdSession createSession() {
        ServiceLoader<DvbTaxCdSession> services = ServiceLoader.load(DvbTaxCdSession.class);
        if (services.iterator().hasNext()) {
            DvbTaxCdSession session = services.iterator().next();
            LOG.info("Loaded Session class: " + session.getClass().getName());
            return session;
        }
        throw new IllegalStateException("Please provide an implementation in META-INF/services/" + DvbTaxCdSession.class.getSimpleName());
    }

    public void headlessStartup() {
        if (this.tmoSession == null) {
            this.tmoSession = this.createSession();
        }
        TaxmeController.writeLanguageToModel(this.tmoSession, this.currentLocale.getLanguage());
    }

    private static void writeLanguageToModel(DvbTaxCdSession tmoSession, String lang) {
        if (tmoSession == null) {
            return;
        }
        if (ApplicationConfig.getInstance().getDmkUserLocale() != null) {
            HashMap<String, ModelItemDTO> userValues = new HashMap<String, ModelItemDTO>();
            ModelItemDTO dtoUserLanguage = new ModelItemDTO((Object)lang);
            dtoUserLanguage.setTouched();
            userValues.put(ApplicationConfig.getInstance().getDmkUserLocale(), dtoUserLanguage);
            tmoSession.updateSilent(userValues);
        }
    }

    public static void updateViewmodusInModel() {
        DvbTaxCdSession tmoSession = TaxmeController.getInstance().getTmoCdSession();
        if (tmoSession == null) {
            return;
        }
        String viewModusDMK = ApplicationConfig.getInstance().getDmkViewmodus();
        if (StringUtils.isBlank((CharSequence)viewModusDMK)) {
            return;
        }
        Mode viewModus = TaxmeController.getInstance().getMode();
        HashMap<String, ModelItemDTO> userValues = new HashMap<String, ModelItemDTO>();
        ModelItemDTO dtoViewmodus = new ModelItemDTO((Object)viewModus.name());
        dtoViewmodus.setTouched();
        userValues.put(viewModusDMK, dtoViewmodus);
        tmoSession.updateSilent(userValues);
        LOG.debug("current view modus is " + String.valueOf(viewModus));
    }

    public void startup(ProgressBar bar) {
        String lastFile;
        if (bar == null) {
            throw new NullPointerException("Progress bar cannot be null");
        }
        bar.setMaximum(100);
        bar.setSelection(25);
        if (this.tmoSession == null) {
            this.tmoSession = this.createSession();
        }
        bar.setSelection(50);
        String lang = TaxmeConfig.getString(LANGUAGE);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
            lang = "fr".equalsIgnoreCase(lang) ? "fr" : "de";
            TaxmeConfig.setValue(LANGUAGE, lang);
        }
        TaxmeController.writeLanguageToModel(this.tmoSession, lang);
        this.mode = Mode.forId((int)TaxmeConfig.getInt("view.mode"), (Mode)Mode.WIZARD);
        GuiUtil.initializeFontRegistry();
        this.imageSource = null;
        this.iconSource = null;
        this.readFileHistory();
        this.initMainHelp();
        bar.setSelection(75);
        this.taxme = Taxme.newInstance();
        this.taxme.setFileHistory(this.fileHistory);
        this.tmoSession.addUndoRedoStateListener(this.taxme);
        this.taxme.setBlockOnOpen(false);
        this.taxme.create();
        CloseListener cli = CloseListenerFactory.getCloseListenerProvider().createCloseListener(this.fileHistory, this.taxme, this.getShell(), this.tmoSession);
        Shell shell = Objects.requireNonNull(this.getShell());
        shell.addListener(21, (Listener)cli);
        shell.getDisplay().addListener(21, (Listener)cli);
        if (OsSupport.isLinuxOs()) {
            shell.getDisplay().getSystemImage(2);
        }
        if (this.declarationOpen) {
            this.update(null, true);
        } else if (TaxmeConfig.getBoolean("lastfile.open") && (lastFile = TaxmeConfig.getString("lastfile.path")) != null) {
            this.openFile(new File(lastFile), true);
        }
        this.setTitle();
        this.setStatusLine();
        bar.setSelection(100);
        this.taxme.open();
    }

    public FileHistory getFileHistory() {
        return this.fileHistory;
    }

    public void close() {
        Objects.requireNonNull(this.getShell()).close();
    }

    public Shell getShell() {
        if (this.taxme == null) {
            return null;
        }
        return this.taxme.getShell();
    }

    private void readFileHistory() {
        for (int i = this.fileHistory.maxSize(); i >= 0; --i) {
            String path = TaxmeConfig.getString("file." + i + ".path");
            if (path == null) continue;
            this.fileHistory.addEntry(new File(path));
        }
    }

    public LocalizationHelper getLocalizationHelper() {
        return LocalizationHelper.newInstance((Locale)this.currentLocale);
    }

    public EditableHelpMapping getShortHelpMapping() {
        return this.shortHelpMapping;
    }

    public @NonNull Mode getMode() {
        return this.mode;
    }

    public void setMode(@NonNull Mode newMode) {
        if (newMode == null) {
            throw new NullPointerException("Edition mode cannot be null.");
        }
        if (newMode != this.mode) {
            this.mode = newMode;
            if (this.mode == Mode.EXPERT) {
                this.wizardLinkDmk = null;
            }
            this.taxme.rebuild();
            this.update();
        }
    }

    public boolean isDeclarationOpen() {
        return this.declarationOpen;
    }

    private void initMainHelp() {
        if (TaxmeConfig.getMainhelpDir() != null) {
            File model = new File(TaxmeConfig.getMainhelpDir() + "help.xml");
            if (!model.exists()) {
                LOG.error("MainHelp not found: " + model.getAbsolutePath());
                return;
            }
            HelpParser.parse(model);
        }
    }

    public boolean isInWizardLink() {
        return this.wizardLinkDmk != null;
    }

    public String getWizardLinkDmk() {
        return this.wizardLinkDmk;
    }

    public boolean isExpertModeEnabled() {
        if (!TaxmeConfig.isWizardModeEnabled()) {
            return true;
        }
        if (!TaxmeConfig.isExpertModeEnabled()) {
            return false;
        }
        DvbTaxCdSession dvbTaxSession = this.getTmoCdSession();
        if (dvbTaxSession == null) {
            return false;
        }
        ModelItemDTO mi = dvbTaxSession.getModelItem("Stammdaten.ExpertModeEnabled");
        if (mi == null || mi.getValue() == null || !(mi.getValue() instanceof Boolean)) {
            return false;
        }
        return (Boolean)mi.getValue();
    }

    public void reloadModel() {
        try {
            this.setModelReload(true);
            File lastFile = null;
            String key = null;
            if (this.isDeclarationOpen()) {
                lastFile = this.closeFile();
                if (this.isDeclarationOpen()) {
                    return;
                }
                key = this.mode == Mode.EXPERT ? this.formAccessKey : this.dataModelKey;
            }
            this.tmoSession = this.createSession();
            Messages.reload();
            if (lastFile != null) {
                this.openFile(lastFile, true);
                if (key != null) {
                    final String key2 = key;
                    Objects.requireNonNull(this.getShell()).getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (TaxmeController.this.mode == Mode.EXPERT) {
                                TaxmeController.this.setFormAccessKey(key2);
                            } else {
                                TaxmeController.this.setDataModelKey(key2);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            DialogUtil.showErrorDialog("error.model.reload", new Object[0]);
            LOG.error("Error reloading model: ", (Throwable)e);
        }
    }

    public Map<DisplayItemUniqueID, GuiEditorEntry> getGuiEdits() {
        if (this.guiEdits == null) {
            this.guiEdits = new HashMap();
        }
        return this.guiEdits;
    }

    public void updateGuiXY(DisplayItemUniqueID id, String form, GuiEditorEntry.Type type, String key, String optionPosition, float x, float y, Point2D.Float originalSize) {
        GuiEditorEntry entry = this.getGuiEdits().get(id);
        Point2D.Float newPosition = new Point2D.Float(ExpertDisplayUtil.toMMFloat((float)x), ExpertDisplayUtil.toMMFloat((float)y));
        if (entry == null) {
            entry = new GuiEditorEntry(newPosition, originalSize, form, type, key, optionPosition);
            this.getGuiEdits().put(id, entry);
        } else {
            entry.setPosition(newPosition);
        }
    }

    public void updateGuiWidthHeight(DisplayItemUniqueID id, String form, GuiEditorEntry.Type type, String key, String optionPosition, Point2D.Float originalPosition, float width, float height) {
        Point2D.Float newSize = new Point2D.Float(ExpertDisplayUtil.toMMFloat((float)width), ExpertDisplayUtil.toMMFloat((float)height));
        GuiEditorEntry entry = this.getGuiEdits().get(id);
        if (entry == null) {
            entry = new GuiEditorEntry(originalPosition, newSize, form, type, key, optionPosition);
            this.getGuiEdits().put(id, entry);
        } else {
            entry.setSize(newSize);
        }
    }

    public void setDebugPart(DebugPart debugPart) {
        this.debugPart = debugPart;
    }

    public DebugPart getDebugPart() {
        return this.debugPart;
    }

    public static boolean isGuiEditEnabled() {
        return Boolean.getBoolean("model.gui.edit.enabled");
    }

    public static boolean isDevelopmentMode() {
        return Boolean.getBoolean("development.mode");
    }

    public void setImportUtil(ImportUtil importUtil) {
        this.importUtil = importUtil;
    }

    public ImportUtil getImportUtil() {
        return this.importUtil;
    }

    public boolean isModelReload() {
        return this.modelReload;
    }

    public void setModelReload(boolean modelReload) {
        this.modelReload = modelReload;
    }

    public boolean isTempTaxfileEnabled() {
        return this.isTempTaxfileEnabled;
    }
}

