/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.lib.update.VersionUtil;
import ch.dvbern.lib.update.exception.ConfigurationException;
import ch.dvbern.lib.update.signatures.JDKTrustManagerProvider;
import ch.dvbern.lib.update.signatures.NullSignatureVerifier;
import ch.dvbern.lib.update.signatures.SignatureVerifier;
import ch.dvbern.lib.update.signatures.TrustManagerProvider;
import ch.dvbern.lib.update.xjc.VersionConfig;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.GuiEditorEntry;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.imports.ImportConfig;
import ch.dvbern.tax.common.presentation.common.util.TableSort;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaxmeConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TaxmeConfig.class);
    private static final String FILE_SEPARATOR = File.separator;
    private static final String DEFAULT_USER_CONF_FILE = "dvbern-tax" + FILE_SEPARATOR + "config" + FILE_SEPARATOR + "user-config.properties";
    private static final String DEFAULT_TABLE_SORTS_FILE = "dvbern-tax" + FILE_SEPARATOR + "config" + FILE_SEPARATOR + "table-sorts.conf";
    private static final String DEFAULT_PRINT_DIR = "dvbern-tax" + FILE_SEPARATOR + "print";
    private static final String DEFAULT_SAVE_DIR = "dvbern-tax" + FILE_SEPARATOR + "tax";
    private static final String GUI_EDITS_FILE_NAME = "gui-edit-config.properties";
    private static final String PROJECT_HOME = new File("").getAbsolutePath() + FILE_SEPARATOR;
    private static Properties config;
    private static DataResource dataResource;
    private static ImportConfig importConfig;
    private static boolean expertModeEnabled;
    private static boolean wizardModeEnabled;
    private static File userConfigFile;
    private static File guiEditConfigFile;
    private static File wizardTableSortsFile;
    private static Map<String, TableSort> wizardTableSorts;
    private static File expertTableSortsFile;
    private static Map<String, TableSort> expertTableSorts;
    private static String applicationVersion;
    private static File saveDir;
    private static File importDir;
    private static File pdfOutputDir;
    private static @NonNull SignatureVerifier updateSignatureVerifier;
    private static @NonNull TrustManagerProvider updateSiteTrustManagerProvider;
    private static final String KEY_VERSION = "version";
    private static final String KEY_VERSION_BARCODE = "versionBarcode";
    private static Map<String, String> versionProperties;

    private TaxmeConfig() {
    }

    public static void load(@NonNull InputStream is) {
        Properties appProps = TaxmeConfig.loadProperties(is, null);
        TaxmeConfig.init(appProps);
    }

    public static void load(@NonNull File configFile) {
        Properties appProps;
        try {
            appProps = TaxmeConfig.loadProperties(configFile, null);
            LOG.info("properties loaded from: {}", (Object)configFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load properties: " + String.valueOf(configFile), e);
        }
        TaxmeConfig.init(appProps);
    }

    private static void init(@NonNull Properties appProps) {
        String userHome = TaxmeConfig.getUserHome();
        String confFileUsb = appProps.getProperty("user.usb.config");
        String confFileAbsolute = appProps.getProperty("user.absolute.config");
        String confFile = appProps.getProperty("user.config", DEFAULT_USER_CONF_FILE);
        if (confFileUsb != null) {
            userConfigFile = new File(confFileUsb);
        } else if (confFileAbsolute != null) {
            userConfigFile = new File(confFileAbsolute);
        } else if (confFile != null) {
            userConfigFile = new File(userHome, confFile);
        }
        TaxmeConfig.createFile(userConfigFile);
        try {
            config = TaxmeConfig.loadProperties(userConfigFile, appProps);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load properties: " + String.valueOf(userConfigFile), e);
        }
        guiEditConfigFile = new File(userConfigFile.getParentFile(), GUI_EDITS_FILE_NAME);
        TaxmeConfig.createFile(guiEditConfigFile);
        String sortsFile = appProps.getProperty("table.sorts.config", DEFAULT_TABLE_SORTS_FILE);
        wizardTableSortsFile = new File(userHome, sortsFile + "." + Mode.WIZARD.getId());
        expertTableSortsFile = new File(userHome, sortsFile + "." + Mode.EXPERT.getId());
    }

    public static String getUserHome() {
        String userHome = System.getenv("USERPROFILE");
        if (userHome == null) {
            userHome = System.getProperty("user.home");
        }
        return userHome;
    }

    private static void createFile(@NonNull File f) {
        if (f.exists()) {
            return;
        }
        File parent = f.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("can't create user config file: " + String.valueOf(f), e);
        }
    }

    private static Properties loadProperties(@NonNull String file, @Nullable Properties def) throws IOException {
        return TaxmeConfig.loadProperties(new File(file), def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(@NonNull File file, @Nullable Properties def) throws IOException {
        InputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(file));
            Properties props = def == null ? new Properties() : new Properties(def);
            props.load(fis);
            Properties properties = props;
            return properties;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.error("Error loading file: " + String.valueOf(file), (Throwable)e);
                }
            }
        }
    }

    private static Properties loadProperties(@Nullable InputStream is, @Nullable Properties def) {
        try {
            Properties props = def == null ? new Properties() : new Properties(def);
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (IOException ioe) {
            throw new RuntimeException("can't load import properties from stream", ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error("error reading inputstream: " + String.valueOf(is), (Throwable)e);
                }
            }
        }
    }

    public static String getString(@NonNull String key) {
        return config.getProperty(key);
    }

    public static String getString(@NonNull String key, @Nullable String defaultValue) {
        return config.getProperty(key, defaultValue);
    }

    public static int getInt(@NonNull String key) {
        return TaxmeConfig.getInt(key, 0);
    }

    public static int getInt(@NonNull String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException("Configuration key cannot be null.");
        }
        String value = config.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static boolean getBoolean(@NonNull String key) {
        return Boolean.valueOf(config.getProperty(key));
    }

    public static boolean getBoolean(@NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("Configuration key cannot be null.");
        }
        String value = config.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            boolean convertedValue = Boolean.valueOf(value);
            return convertedValue;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("impossible to convert string to boolean for property: " + key);
        }
    }

    public static void setValue(@NonNull String key, @NonNull boolean value) {
        TaxmeConfig.setValue(key, Boolean.toString(value));
    }

    public static void setValue(@NonNull String key, @NonNull String value) {
        config.setProperty(key, value);
    }

    public static void setValue(@NonNull String key, @NonNull int value) {
        TaxmeConfig.setValue(key, Integer.toString(value));
    }

    public static void remove(@NonNull String key) {
        config.remove(key);
    }

    private static String getProjectHome() {
        return PROJECT_HOME;
    }

    public static File getSaveDir() {
        if (saveDir == null) {
            String saveDirNameAbsolutePath = config.getProperty("user.savedir.absolute.path");
            String saveDirNameUsbPath = config.getProperty("user.savedir.usb.path");
            File tmpSaveDir = null;
            if (saveDirNameAbsolutePath != null) {
                tmpSaveDir = new File(saveDirNameAbsolutePath);
            }
            if (saveDirNameUsbPath != null) {
                tmpSaveDir = new File(saveDirNameUsbPath);
            }
            if (tmpSaveDir != null) {
                saveDir = tmpSaveDir;
            } else {
                String dir = config.getProperty("user.savedir", DEFAULT_SAVE_DIR);
                saveDir = new File(TaxmeConfig.getUserHome(), dir);
            }
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
        }
        return saveDir;
    }

    public static File getImportDir() {
        if (importDir == null) {
            String importDirNameAbsolutePath = config.getProperty("user.importdir.absolute.path");
            String importDirNameUsbPath = config.getProperty("user.importdir.usb.path");
            File tmpImportDir = null;
            if (importDirNameAbsolutePath != null) {
                tmpImportDir = new File(importDirNameAbsolutePath);
            }
            if (importDirNameUsbPath != null) {
                tmpImportDir = new File(importDirNameUsbPath);
            }
            if (tmpImportDir != null) {
                importDir = tmpImportDir;
            } else {
                String importDirName = config.getProperty("user.importdir", DEFAULT_SAVE_DIR);
                importDir = new File(TaxmeConfig.getUserHome(), importDirName);
            }
            if (!importDir.exists()) {
                importDir.mkdirs();
            }
        }
        return importDir;
    }

    public static File getPdfOutputDir() {
        if (pdfOutputDir == null) {
            String pdfOutputDirNameAbsolutePath = config.getProperty("user.printdir.absolute.path");
            String pdfOutputDirNameUsbPath = config.getProperty("user.printdir.usb.path");
            File tmpPdfOutputDir = null;
            if (pdfOutputDirNameAbsolutePath != null) {
                tmpPdfOutputDir = new File(pdfOutputDirNameAbsolutePath);
            }
            if (pdfOutputDirNameUsbPath != null) {
                tmpPdfOutputDir = new File(pdfOutputDirNameUsbPath);
            }
            if (tmpPdfOutputDir != null) {
                pdfOutputDir = tmpPdfOutputDir;
            } else {
                String dirName = config.getProperty("user.printdir", DEFAULT_PRINT_DIR);
                pdfOutputDir = new File(TaxmeConfig.getUserHome(), dirName);
            }
            if (!pdfOutputDir.exists()) {
                pdfOutputDir.mkdirs();
            }
        }
        return pdfOutputDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeGuiEdits() {
        Map<DisplayItemUniqueID, GuiEditorEntry> guiEdits = TaxmeController.getInstance().getGuiEdits();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(guiEditConfigFile));
            for (Map.Entry<DisplayItemUniqueID, GuiEditorEntry> entry : guiEdits.entrySet()) {
                writer.write(String.valueOf(entry.getKey()) + "=" + entry.getValue().printXPath());
                writer.newLine();
            }
        }
        catch (IOException e) {
            try {
                LOG.error("Failed to persist GuiEdit configuration.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public static void store() {
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(userConfigFile));
            config.store(fos, null);
            TaxmeConfig.storeGuiEdits();
        }
        catch (IOException e) {
            LOG.error("error during store", (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    LOG.error("error during store (finally)", (Throwable)e);
                }
            }
        }
        TaxmeConfig.saveMap(expertTableSorts, expertTableSortsFile);
        TaxmeConfig.saveMap(wizardTableSorts, wizardTableSortsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveMap(@Nullable Map<String, TableSort> map, @NonNull File file) {
        if (map == null) {
            return;
        }
        TaxmeConfig.createFile(file);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            oos.writeObject(map);
        }
        catch (IOException e) {
            LOG.error("Error saving map: " + String.valueOf(file), (Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    LOG.error("Error saving map (finally): " + String.valueOf(file), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, TableSort> readMap(@NonNull File file) {
        if (!file.exists()) {
            return new HashMap<String, TableSort>();
        }
        ObjectInputStream ois = null;
        try {
            Map theMap;
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Map map = theMap = (Map)ois.readObject();
            return map;
        }
        catch (Exception e) {
            LOG.error("Error reading map: " + String.valueOf(file), (Throwable)e);
            HashMap<String, TableSort> hashMap = new HashMap<String, TableSort>();
            return hashMap;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    LOG.error("Error reading map: " + String.valueOf(file), (Throwable)e);
                }
            }
        }
    }

    public static String getWelcomeFilePath() {
        return TaxmeConfig.getInfoFilePath("welcome.html");
    }

    public static String getAboutFilePath() {
        return TaxmeConfig.getInfoFilePath("about.html");
    }

    public static String getShorthelpFilePath(String fileName) {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("shorthelp.dir") + TaxmeConfig.getLanguage() + "/" + fileName;
    }

    public static String getShorthelpDir() {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("shorthelp.dir");
    }

    public static String getShorthelpFilename() {
        return TaxmeConfig.getString("shorthelp.filename", "helpMapping.properties");
    }

    public static String getShortHelpMappingFilePath() {
        return TaxmeConfig.getShorthelpDir() + TaxmeConfig.getShorthelpFilename();
    }

    public static String getMainhelpFilePath(@NonNull String fileName) {
        return TaxmeConfig.getMainhelpDir() + TaxmeConfig.getLanguage() + FILE_SEPARATOR + fileName;
    }

    public static @Nullable String getMainhelpDir() {
        if (TaxmeConfig.getString("mainhelp.dir") == null) {
            return null;
        }
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("mainhelp.dir");
    }

    public static String getIconFilePath(@NonNull String fileName) {
        return TaxmeConfig.getIconDir() + fileName;
    }

    public static String getIconDir() {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("icon.dir");
    }

    public static String getImageDir() {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("image.dir") + TaxmeConfig.getLanguage() + FILE_SEPARATOR;
    }

    public static String getFormImagesDir() {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("forms.dir") + TaxmeConfig.getLanguage() + FILE_SEPARATOR;
    }

    public static String getImageFilePath(@NonNull String fileName) {
        return TaxmeConfig.getImageDir() + FILE_SEPARATOR + fileName;
    }

    public static String getResourceBundlePath(@NonNull String lang) {
        if (lang == null) {
            throw new NullPointerException("Lang cannot be null.");
        }
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("resources.dir") + "resources_" + lang + ".properties";
    }

    public static String getDocumentDir(@NonNull boolean translate) {
        if (translate) {
            return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("doc.dir") + FILE_SEPARATOR + TaxmeConfig.getLanguage() + FILE_SEPARATOR;
        }
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("doc.dir") + FILE_SEPARATOR;
    }

    public static String getInfoFilePath(@NonNull String fileName) {
        return TaxmeConfig.getProjectHome() + TaxmeConfig.getString("info.dir") + TaxmeConfig.getLanguage() + FILE_SEPARATOR + fileName;
    }

    private static String getLanguage() {
        return TaxmeController.getInstance().getLanguage();
    }

    public static void setDataResource(@NonNull DataResource resource) {
        dataResource = resource;
    }

    public static DataResource getDataResource() {
        return dataResource;
    }

    public static ImportConfig getImportConfig() {
        if (importConfig == null) {
            Properties impProps;
            Properties impConf;
            String resDir = TaxmeConfig.getProjectHome() + TaxmeConfig.getString("resources.dir");
            try {
                impConf = TaxmeConfig.loadProperties(resDir + "importConfig.properties", null);
            }
            catch (IOException e) {
                LOG.error("Could not load importConfig.properties!", (Throwable)e);
                impConf = new Properties();
            }
            try {
                impProps = TaxmeConfig.loadProperties(resDir + "imports.properties", null);
            }
            catch (IOException e) {
                LOG.warn("Could not load imports.properties: " + e.getMessage());
                impProps = new Properties();
            }
            importConfig = new ImportConfig(impConf, impProps);
        }
        return importConfig;
    }

    public static boolean isExpertModeEnabled() {
        return expertModeEnabled;
    }

    public static void setExpertModeEnabled(boolean expertModeEnabled) {
        TaxmeConfig.expertModeEnabled = expertModeEnabled;
    }

    public static boolean isWizardModeEnabled() {
        return wizardModeEnabled;
    }

    public static void setWizardModeEnabled(boolean wizardModeEnabled) {
        TaxmeConfig.wizardModeEnabled = wizardModeEnabled;
    }

    public static void check() {
        if (config == null) {
            throw new RuntimeException("Configuration not loaded. Please load it with TaxmeConfig.loadConfig(..) .");
        }
        if (dataResource == null) {
            throw new RuntimeException("DataResource not configured. Please set it with DvbTaxSession.setDataResource(..) .");
        }
        if (!expertModeEnabled && !wizardModeEnabled) {
            throw new RuntimeException("Expert and Wizard Mode are disabled. Please enable at least one Mode.");
        }
    }

    public static String getApplicationVersion() {
        if (applicationVersion == null) {
            applicationVersion = "";
            if (versionProperties == null) {
                TaxmeConfig.readVersionProperties();
            }
            if (versionProperties != null && !versionProperties.isEmpty() && versionProperties.containsKey(KEY_VERSION)) {
                applicationVersion = versionProperties.get(KEY_VERSION);
            } else {
                LOG.error("could not read application version from client version configuration");
            }
        }
        return applicationVersion;
    }

    public static @Nullable String getApplicationVersionBarcode() {
        if (versionProperties == null) {
            TaxmeConfig.readVersionProperties();
        }
        if (versionProperties != null) {
            return versionProperties.get(KEY_VERSION_BARCODE);
        }
        return null;
    }

    private static void readVersionProperties() {
        VersionConfig versionConfig;
        try {
            versionConfig = VersionUtil.loadVersionConfig();
        }
        catch (ConfigurationException e) {
            throw new ApplicationException("Cannot load version configuration file", (Throwable)e);
        }
        HashMap<String, String> versionMap = new HashMap<String, String>(2);
        versionMap.put(KEY_VERSION, versionConfig.getAppName() + " " + versionConfig.getVersion());
        versionMap.put(KEY_VERSION_BARCODE, versionConfig.getVersion());
        versionProperties = versionMap;
    }

    public static @Nullable File getUserConfigFile() {
        return userConfigFile;
    }

    public static boolean isDebugEnabled() {
        return TaxmeConfig.getBoolean("DebugEnabled");
    }

    public static Map<String, TableSort> getTableSorts(@NonNull Mode mode) {
        if (mode == Mode.EXPERT) {
            if (expertTableSorts == null) {
                expertTableSorts = TaxmeConfig.readMap(expertTableSortsFile);
            }
            return expertTableSorts;
        }
        if (wizardTableSorts == null) {
            wizardTableSorts = TaxmeConfig.readMap(wizardTableSortsFile);
        }
        return wizardTableSorts;
    }

    public static boolean isOverlyLongTextAllowed() {
        return Boolean.valueOf(config.getProperty("validation.overlyLongTextAllowed", "false"));
    }

    public static String getFormStateDMK() {
        return TaxmeConfig.getString("formStateDMK");
    }

    public static @NonNull SignatureVerifier getUpdateSignatureVerifier() {
        return updateSignatureVerifier;
    }

    public static void setUpdateSignatureVerifier(@NonNull SignatureVerifier updateSignatureVerifier) {
        TaxmeConfig.updateSignatureVerifier = Objects.requireNonNull(updateSignatureVerifier);
    }

    public static @NonNull TrustManagerProvider getUpdateSiteTrustManagerProvider() {
        return updateSiteTrustManagerProvider;
    }

    public static void setUpdateSiteTrustManagerProvider(@NonNull TrustManagerProvider updateSiteTrustManagerProvider) {
        TaxmeConfig.updateSiteTrustManagerProvider = Objects.requireNonNull(updateSiteTrustManagerProvider);
    }

    static {
        expertModeEnabled = true;
        wizardModeEnabled = true;
        updateSignatureVerifier = new NullSignatureVerifier();
        updateSiteTrustManagerProvider = new JDKTrustManagerProvider();
    }
}

