/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.bd.cd;

import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoRedoSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(UndoRedoSnapshot.class);
    private final UndoRedoStack undoStack;
    private final UndoRedoStack redoStack;
    private final UndoRedoStack snapshots;
    private final List<UndoRedoStateListener> listeners = new ArrayList<UndoRedoStateListener>();

    public UndoRedoSnapshot() {
        this.undoStack = new UndoRedoStack(100);
        this.redoStack = new UndoRedoStack(100);
        this.snapshots = new UndoRedoStack(100);
    }

    public void addUndoRedoStateListener(UndoRedoStateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeUndoRedoStateListener(UndoRedoStateListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners() {
        for (UndoRedoStateListener listener : this.listeners) {
            listener.undoRedoStateChanged(this.isUndoable(), this.isRedoable());
        }
    }

    public void update(Map<String, ModelItemDTO> undoMap, String dmk) {
        if (!undoMap.isEmpty()) {
            this.undoStack.push(new UndoRedoDTO(undoMap, dmk));
            this.redoStack.clear();
        }
        this.notifyListeners();
    }

    public boolean isUndoable() {
        return !this.undoStack.isEmpty();
    }

    public boolean isRedoable() {
        return !this.redoStack.isEmpty();
    }

    public void clear() {
        this.redoStack.clear();
        this.undoStack.clear();
        this.snapshots.clear();
        this.notifyListeners();
    }

    public UndoRedoSnapshotDTO undo(Map<String, ModelItemDTO> dataModel, String dmk) {
        if (this.undoStack.isEmpty()) {
            return null;
        }
        UndoRedoSnapshotDTO undoInfo = (UndoRedoSnapshotDTO)this.undoStack.pop();
        if (undoInfo instanceof CreateSnapshotDTO) {
            if (!this.snapshots.isEmpty()) {
                this.snapshots.pop();
            } else {
                LOG.debug("Snapshot Stack is empty!");
            }
            this.redoStack.push(new CreateSnapshotDTO(dataModel, dmk));
        }
        if (undoInfo instanceof BacktoSnapshotDTO) {
            BacktoSnapshotDTO bsDTO = new BacktoSnapshotDTO(dataModel, dmk);
            this.snapshots.push(bsDTO);
            this.redoStack.push(bsDTO);
        }
        if (undoInfo instanceof UndoRedoDTO) {
            Map<String, ModelItemDTO> undoMap = undoInfo.getDataModel();
            HashMap<String, ModelItemDTO> redoMap = new HashMap<String, ModelItemDTO>();
            for (Map.Entry<String, ModelItemDTO> me : undoMap.entrySet()) {
                String key = me.getKey();
                ModelItemDTO value = me.getValue();
                ModelItemDTO oldValue = dataModel.get(key);
                if (value != null) {
                    dataModel.put(key, value);
                } else {
                    dataModel.remove(key);
                }
                redoMap.put(key, oldValue);
            }
            this.redoStack.push(new UndoRedoDTO(redoMap, dmk));
            undoInfo = new UndoRedoDTO(dataModel, undoInfo.getDmk());
        }
        this.notifyListeners();
        return undoInfo;
    }

    public UndoRedoSnapshotDTO redo(Map<String, ModelItemDTO> dataModel, String dmk) {
        if (this.redoStack.isEmpty()) {
            return null;
        }
        UndoRedoSnapshotDTO redoInfo = (UndoRedoSnapshotDTO)this.redoStack.pop();
        if (redoInfo instanceof CreateSnapshotDTO) {
            CreateSnapshotDTO csDTO = new CreateSnapshotDTO(dataModel, dmk);
            this.snapshots.push(csDTO);
            this.undoStack.push(csDTO);
        }
        if (redoInfo instanceof BacktoSnapshotDTO) {
            if (!this.snapshots.isEmpty()) {
                this.snapshots.pop();
            } else {
                LOG.debug("Snapshot Stack is empty!");
            }
            this.redoStack.push(new BacktoSnapshotDTO(dataModel, dmk));
        }
        if (redoInfo instanceof UndoRedoDTO) {
            Map<String, ModelItemDTO> redoMap = redoInfo.getDataModel();
            HashMap<String, ModelItemDTO> undoMap = new HashMap<String, ModelItemDTO>();
            for (Map.Entry<String, ModelItemDTO> me : redoMap.entrySet()) {
                String key = me.getKey();
                ModelItemDTO value = me.getValue();
                ModelItemDTO newValue = dataModel.get(key);
                if (value != null) {
                    dataModel.put(key, value);
                } else {
                    dataModel.remove(key);
                }
                undoMap.put(key, newValue);
            }
            this.undoStack.push(new UndoRedoDTO(undoMap, dmk));
            redoInfo = new UndoRedoDTO(dataModel, redoInfo.getDmk());
        }
        this.notifyListeners();
        return redoInfo;
    }

    public void createModelSnapshot(Map<String, ModelItemDTO> dataModel, String dmk) {
        this.snapshots.push(new CreateSnapshotDTO(new HashMap<String, ModelItemDTO>(dataModel), dmk));
        this.undoStack.push(new CreateSnapshotDTO(dataModel, dmk));
        this.redoStack.clear();
        this.notifyListeners();
    }

    public UndoRedoSnapshotDTO backtoModelSnapshot(Map<String, ModelItemDTO> dataModel, String dmk) {
        if (this.snapshots.isEmpty()) {
            return null;
        }
        UndoRedoSnapshotDTO ursDTO = (UndoRedoSnapshotDTO)this.snapshots.pop();
        this.undoStack.push(new BacktoSnapshotDTO(dataModel, dmk));
        this.redoStack.clear();
        this.notifyListeners();
        return ursDTO;
    }

    private static class UndoRedoStack {
        private final LinkedList<Object> list = new LinkedList();
        private final int maxSize;

        public UndoRedoStack(int maxSize) {
            this.maxSize = maxSize;
        }

        public void push(Object obj) {
            this.list.addLast(obj);
            if (this.list.size() > this.maxSize) {
                this.list.removeFirst();
            }
        }

        public Object pop() {
            if (this.isEmpty()) {
                return null;
            }
            return this.list.removeLast();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void clear() {
            this.list.clear();
        }
    }

    public static interface UndoRedoStateListener {
        public void undoRedoStateChanged(boolean var1, boolean var2);
    }

    private static class BacktoSnapshotDTO
    extends UndoRedoSnapshotDTO {
        public BacktoSnapshotDTO(Map<String, ModelItemDTO> dataModel, String dmk) {
            super(dataModel, dmk);
        }
    }

    private static class CreateSnapshotDTO
    extends UndoRedoSnapshotDTO {
        public CreateSnapshotDTO(Map<String, ModelItemDTO> dataModel, String dmk) {
            super(dataModel, dmk);
        }
    }

    private static class UndoRedoDTO
    extends UndoRedoSnapshotDTO {
        public UndoRedoDTO(Map<String, ModelItemDTO> dataModel, String dmk) {
            super(dataModel, dmk);
        }
    }

    public static class UndoRedoSnapshotDTO {
        private final Map<String, ModelItemDTO> dataModel;
        private final String dmk;

        public UndoRedoSnapshotDTO(Map<String, ModelItemDTO> dataModel, String dmk) {
            this.dataModel = dataModel;
            this.dmk = dmk;
        }

        public Map<String, ModelItemDTO> getDataModel() {
            return this.dataModel;
        }

        public String getDmk() {
            return this.dmk;
        }
    }
}

