/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.utils;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TableIterator {
    private static final Iterator<String> EMPTY_ITERATOR = new Iterator<String>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            throw new NoSuchElementException("Iterator is empty");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator is read-only");
        }
    };
    static final TableIterator EMPTY = new TableIterator("", EMPTY_ITERATOR, 0);
    private final String tableDmk;
    private final Iterator<String> wrappedItr;
    private final int size;
    private String entryDmk = null;

    TableIterator(String tableDmk, Iterator<String> wrappedItr, int size) {
        assert (tableDmk != null && wrappedItr != null && size >= 0);
        this.tableDmk = tableDmk;
        this.wrappedItr = wrappedItr;
        this.size = size;
    }

    public boolean hasNext() {
        return this.wrappedItr.hasNext();
    }

    public boolean next() {
        if (this.wrappedItr.hasNext()) {
            this.entryDmk = this.tableDmk + "." + this.wrappedItr.next();
            return true;
        }
        return false;
    }

    public String merge(String lmk) {
        if (lmk == null) {
            throw new NullPointerException("Logic model item key cannot be null");
        }
        if (this.entryDmk == null) {
            throw new IllegalStateException("Call 'next' first");
        }
        return EngineUtil.mergeModelKey((String)lmk, (String)this.entryDmk);
    }

    public String append(String dmkSuffix) {
        if (dmkSuffix == null) {
            throw new NullPointerException("Data model key suffix cannot be null");
        }
        if (this.entryDmk == null) {
            throw new IllegalStateException("Call 'next' first");
        }
        return this.entryDmk + "." + dmkSuffix;
    }

    public int getSize() {
        return this.size;
    }
}

