/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.utils;

import ch.dvbern.tax.common.ejb.util.CDIHelper;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pm.utils.GeConstants;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.MDC;

public final class SharedUtils {
    public static final String MDC_PP_REQUEST_ID = "idTransaction";
    private static final Set<String> UPLOAD_FORM_FILTER_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Barcode#", "acomptes#", "Justificatifs#", "recapitulationImpots#")));

    private SharedUtils() {
    }

    public static void setupMDC(String requestId) {
        if (requestId == null) {
            MDC.remove((String)MDC_PP_REQUEST_ID);
        } else {
            MDC.put((String)MDC_PP_REQUEST_ID, (String)requestId);
        }
    }

    @Nonnull
    public static String translate(@Nonnull String key, Object ... args) {
        if (key == null) {
            throw new NullPointerException("Resource key cannot be null.");
        }
        return CDIHelper.getResourceBundleManager().translate(key, GeConstants.DEFAULT_LOCALE, args);
    }

    @Nonnull
    public static ModelItemDTO createTouchedItem(@Nullable Object value) {
        ModelItemDTO item = new ModelItemDTO(value);
        item.setTouched();
        return item;
    }

    @Nonnull
    public static List<FormKey> getUploadFormKeys(@Nonnull DvbTaxSession session) {
        if (session == null) {
            throw new NullPointerException("Session cannot be null.");
        }
        List navItems = session.getExpertNavigationItems();
        ArrayList<FormKey> forms = new ArrayList<FormKey>(navItems.size());
        for (ExpertDisplayInfoDTO.NavigationDTO navItem : navItems) {
            if (navItem.getPrintState() == 12 || !navItem.isPrintGesamtausdruck()) continue;
            SharedUtils.addSubItems(navItem, forms, UPLOAD_FORM_FILTER_SET);
        }
        forms.remove(new FormKey("Barcode#", Mode.EXPERT));
        forms.remove(new FormKey("Barcode_af#", Mode.EXPERT));
        return forms;
    }

    private static void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navItem, List<FormKey> forms, Set<String> filterSet) {
        assert (navItem != null && forms != null && filterSet != null);
        String key = navItem.getAccessKey();
        if (filterSet.contains(key)) {
            return;
        }
        if (navItem.getSubItems() != null) {
            for (ExpertDisplayInfoDTO.NavigationDTO childDTO : navItem.getSubItems()) {
                SharedUtils.addSubItems(childDTO, forms, filterSet);
            }
        } else {
            forms.add(new FormKey(key, Mode.EXPERT));
        }
    }

    @Nonnull
    public static String formatDigest(MessageDigest digest) {
        if (digest == null) {
            throw new NullPointerException("Digest cannot be null.");
        }
        int digestLength = digest.getDigestLength();
        String fmt = digestLength > 0 ? "%0" + digestLength * 2 + "x" : "%x";
        return String.format(fmt, new BigInteger(1, digest.digest()));
    }
}

