/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.utils;

import ch.dvbern.tax.common.engine.LogicModelItemInfoDTO;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pm.utils.TableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DataModelValuesUtil {
    private static final Number ZERO = 0;
    private static final Pattern DMK_TABLE_INDEX_PTN = Pattern.compile("\\.[0-9]+\\.");
    private final Map<String, ModelItemDTO> dataModel;
    private final Map<String, LogicModelItemInfoDTO> lmiInfoMap;

    public DataModelValuesUtil(DvbTaxSession session) {
        if (session == null) {
            throw new NullPointerException("Session cannot be null");
        }
        this.dataModel = session.getDataModel();
        this.lmiInfoMap = session.getLogicModelItemsInfo();
    }

    public String getString(String dmk) {
        return this.get(dmk, String.class, null);
    }

    public String getString(String dmk, String defaultValue) {
        return this.get(dmk, String.class, defaultValue);
    }

    public boolean getBoolean(String dmk) {
        return this.get(dmk, Boolean.class, Boolean.FALSE);
    }

    public Number getNumber(String dmk) {
        return this.getNumber(dmk, ZERO);
    }

    public Number getNumber(String dmk, Number defaultValue) {
        return this.get(dmk, Number.class, defaultValue);
    }

    public Date getDate(String dmk) {
        return this.get(dmk, Date.class, null);
    }

    public <T> T get(String dmk, Class<T> type, T defaultValue) {
        Object obj;
        if (dmk == null) {
            throw new NullPointerException("Data model key cannot be null");
        }
        if (type == null) {
            throw new NullPointerException("Value type cannot be null");
        }
        ModelItemDTO item = this.dataModel.get(dmk);
        if (!this.lmiInfoMap.containsKey(DataModelValuesUtil.removeTableIndices(dmk))) {
            throw new IllegalArgumentException("No logic model item form DMK: " + dmk);
        }
        Object object = obj = item != null ? item.getValue() : null;
        if (obj == null) {
            return defaultValue;
        }
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException("Wrong element type, expected: " + type.getName() + " got: " + obj.getClass().getName() + " for DMK: " + dmk);
        }
        return type.cast(obj);
    }

    public TableIterator getTableIterator(String tableDmk) {
        if (tableDmk == null) {
            throw new NullPointerException("Data model key cannot be null");
        }
        if (!this.lmiInfoMap.containsKey(DataModelValuesUtil.removeTableIndices(tableDmk))) {
            throw new IllegalArgumentException("No logic model item form data model key: " + tableDmk);
        }
        Set indexes = this.get(tableDmk, Set.class, null);
        if (indexes == null) {
            return TableIterator.EMPTY;
        }
        ArrayList indexesSorted = new ArrayList(indexes);
        Collections.sort(indexesSorted);
        return new TableIterator(tableDmk, indexesSorted.iterator(), indexesSorted.size());
    }

    private static String removeTableIndices(String dmk) {
        assert (dmk != null);
        return DMK_TABLE_INDEX_PTN.matcher(dmk).replaceAll(".");
    }
}

