/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NoValeur
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3258413941062578742L;
    private final Pattern patternValidate = Pattern.compile("(\\d)(\\ ?)(\\d{1,3})(\\ ?)(\\d{1,3})");

    public NoValeur() {
        super(String.class);
    }

    @Nullable
    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noValeur");
        }
        return s;
    }

    @Nullable
    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Nonnull
    public String getUserInputRegExpPattern() {
        return "[0-9]{1,1}(\\ ?)[0-9]{0,3}(\\ ?)[0-9]{0,3}";
    }
}

