/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NoParcelle
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3618977871490462256L;
    private final Pattern patternValidate = Pattern.compile("(\\d\\d)(\\-?)(\\d{1,6})");
    private final Pattern patternRender = Pattern.compile("(\\d\\d)(\\d{1,6})");

    public NoParcelle() {
        super(String.class);
    }

    @Nullable
    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noParcelle");
        }
        return s;
    }

    @Nullable
    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "-" + m.group(2);
        }
        return o.toString();
    }

    public int getMaxLength() {
        return 9;
    }
}

