/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.common.imports;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.TaxFileImporter;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeTaxFileImporter
extends TaxFileImporter {
    private static final Logger LOG = LoggerFactory.getLogger(GeTaxFileImporter.class);
    private static String fileDir = (String)(System.getProperty("project.base.dir") != null ? System.getProperty("project.base.dir") + "/" : "") + "config/cd/resources/";
    private static final String TAX_YEAR_KEY = "Declaration.PeriodeTaxation";
    private static final String TAX_YEAR_KEY_AF = "Declaration_af.PeriodeTaxation";
    private static final String TAX_YEAR_NOT_VORJAHR_ERROR_CODE = "error.import.tax.year.not.vorjahr";
    private static final String DECLARATION_FORM4 = "Declaration.Form4";
    private static final String DECLARATION_FORM4_AF = "Declaration_af.Form4_af";
    private static final String DECLARATION_FORM2_AF = "Declaration_af.Form2_af";
    private static final String DECLARATION_FORM2_SA = "Declaration.Form2";
    private static final String ANNEXE_E = "AnnexeE";
    private static final String ANNEXE_F = "AnnexeF";
    private static final String ANNEXE_G = "AnnexeG";
    private static final String ANNEXE_F_AF = "AnnexeF_af";
    private static final String ANNEXE_J_AJ = "AnnexeJ.AJ";
    private static final String ANNEXE_J_AJ_AF = "AnnexeJ_af.AJ_af";
    private static final String ANNEXE_K_AK = "AnnexeK.AK";
    private static final String ANNEXE_K_AK_AF = "AnnexeK_af.AK_af";
    private static final String ANNEXE_M_PAGE2_PERTES_FISCALES = "AnnexeM.Page2.PertesFiscales";
    private static final String PERTES_REPORTEES = ".PertesReportees";
    private static final String RESULTAT_FISCAL = ".ResultatFiscal";
    private static final String IMM_LOUE_GENEVE = ".ImmLoueGeneve";
    private static final String IMM_OCCUPE_GENEVE = ".ImmOccupeGeneve";
    private static final String VALEUR_FISCALE = ".ValeurFiscale";
    private static final String TAUX_CAPITALISATION = ".TauxCapitalisation";
    private static final String FOR_PRINCIPAL = ".ForPrincipal";
    private static final String FORS_SECONDAIRES = ".ForsSecondaires";
    private static final String FORS_SPECIAUX = ".ForsSpeciaux";
    private static final String PAGE1 = ".Page1";
    private static final String PAGE1_AF = ".Page1_af";
    private static final String DEBUT_A = ".DebutA";
    private static final String DEBUT_B = ".DebutB";
    private static final String DEBUT_C = ".DebutC";
    private static final String DEBUT_D = ".DebutD";
    private static final String DEBUT_E = ".DebutE";
    private static final String FIN_A = ".FinA";
    private static final String FIN_B = ".FinB";
    private static final String FIN_C = ".FinC";
    private static final String FIN_D = ".FinD";
    private static final String FIN_E = ".FinE";
    private static final String SELECTION_SA = "Selection.SA";
    private static final String SELECTION_AF = "Selection.AF";
    private boolean selectionSa;
    private boolean selectionAf;
    private static final Map<String, String> DECLA_PAGE1_MAP;
    private static final Map<String, String> DECLA_PAGE1_AF_MAP;
    private static final Map<String, String> ANNEXE_F_MAP;
    private static final Map<String, String> ANNEXE_F_AF_MAP;
    private static final Map<String, String> ANNEXE_J_MAP;
    private static final Map<String, String> ANNEXE_J_AF_MAP;
    private static final Map<String, String> ANNEXE_K_MAP;
    private static final Map<String, String> ANNEXE_K_AF_MAP;

    public GeTaxFileImporter(ImportContext ctx) {
        super(ctx);
    }

    protected void importOldModelItems() throws ImportException {
        ModelItemDTO afItem;
        Long lastYear = ApplicationConfig.getInstance().getVorjahr();
        Long taxYear = null;
        ModelItemDTO taxYearItem = (ModelItemDTO)this.getOldDataModel().get(TAX_YEAR_KEY);
        ModelItemDTO taxYearItemAF = (ModelItemDTO)this.getOldDataModel().get(TAX_YEAR_KEY_AF);
        if (taxYearItem != null) {
            value = taxYearItem.getValue();
            taxYear = this.extractTaxYear(value);
        } else if (taxYearItemAF != null) {
            value = taxYearItemAF.getValue();
            taxYear = this.extractTaxYear(value);
        } else {
            taxYear = ApplicationConfig.getInstance().getVorjahr();
            LOG.error("Failed to retrieve current tax year in imported tax file, assuming default: " + taxYear);
        }
        if (lastYear.equals(taxYear)) {
            if (TaxmeConfig.getBoolean((String)"oap", (boolean)true)) {
                super.importOldModelItems(true);
            } else {
                super.importOldModelItems();
            }
        } else {
            throw new ImportException(TAX_YEAR_NOT_VORJAHR_ERROR_CODE);
        }
        ModelItemDTO saItem = (ModelItemDTO)this.getNewDataModel().get(SELECTION_SA);
        if (saItem != null && saItem.getValue() instanceof Boolean) {
            this.selectionSa = (Boolean)saItem.getValue();
        }
        if ((afItem = (ModelItemDTO)this.getNewDataModel().get(SELECTION_AF)) != null && afItem.getValue() instanceof Boolean) {
            this.selectionAf = (Boolean)afItem.getValue();
        }
        if (this.selectionSa) {
            this.deleteDataFromAnnexeM();
            this.traitePertesFiscalesSAICC();
            this.traitePertesFiscalesSAIFD();
        }
        if (this.selectionAf) {
            this.traitePertesFiscalesAFICC();
            this.traitePertesFiscalesAFIFD();
        }
    }

    private Long extractTaxYear(Object value) {
        Long retValue = null;
        if (value != null) {
            if (value instanceof Long) {
                retValue = (Long)value;
            } else {
                try {
                    retValue = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    LOG.warn("tax year conversion failed", (Throwable)e);
                    retValue = null;
                }
            }
        }
        return retValue;
    }

    protected void storeInNewModel(String currentDmk, ModelItemDTO value) throws ImportException {
        boolean storeInModell = true;
        String logicModelKey = EngineUtil.removeTableIndices((String)currentDmk);
        for (String current : DECLA_PAGE1_MAP.keySet()) {
            value = this.updateDeclaPage1(currentDmk, value, logicModelKey, current, DECLA_PAGE1_MAP);
        }
        for (String current : DECLA_PAGE1_AF_MAP.keySet()) {
            value = this.updateDeclaPage1(currentDmk, value, logicModelKey, current, DECLA_PAGE1_AF_MAP);
        }
        if (storeInModell) {
            super.storeInNewModel(currentDmk, value);
        }
    }

    private ModelItemDTO updateDeclaPage1(String key, ModelItemDTO value, String logicModelKey, String current, Map<String, String> declaPage1Map) throws ImportException {
        if (logicModelKey.equals(current)) {
            Object dateObj;
            String lmk = declaPage1Map.get(current);
            String dmk = EngineUtil.mergeModelKey((String)lmk, (String)key);
            ModelItemDTO mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            if (mi != null && mi.getValue() != null && (dateObj = mi.getValue()) instanceof Date) {
                String dmkDateDebut = EngineUtil.removeLastKeyPart((String)dmk) + ".DateDeb";
                ModelItemDTO miDateDebut = (ModelItemDTO)this.getOldDataModel().get(dmkDateDebut);
                if (miDateDebut != null) {
                    miDateDebut = miDateDebut.clone((Object)this.addDay((Date)dateObj, 1));
                    super.storeInNewModel(dmkDateDebut, miDateDebut);
                }
                value = value.clone((Object)this.addYear((Date)dateObj, 1));
            }
        }
        return value;
    }

    private void deleteDataFromAnnexeM() throws ImportException {
        ArrayList<String> annexeMPertesFiscales = new ArrayList<String>();
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1NonImposableSuisse");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1NonImposableCanton");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteFinanciereHoldingExempte");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteFinanciereDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteFinanciere15Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteFinanciere2_5Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteCommercialeDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteCommerciale20Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteCommercialeAutre");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2NonImposableSuisse");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2NonImposableCanton");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteFinanciereHoldingExempte");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteFinanciereDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteFinanciere15Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteFinanciere2_5Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteCommercialeDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteCommerciale20Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteCommercialeAutre");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3NonImposableSuisse");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3NonImposableCanton");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteFinanciereHoldingExempte");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteFinanciereDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteFinanciere15Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteFinanciere2_5Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteCommercialeDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteCommerciale20Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteCommercialeAutre");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4NonImposableSuisse");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4NonImposableCanton");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteFinanciereHoldingExempte");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteFinanciereDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteFinanciere15Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteFinanciere2_5Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteCommercialeDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteCommerciale20Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteCommercialeAutre");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5NonImposableSuisse");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5NonImposableCanton");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteFinanciereHoldingExempte");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteFinanciereDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteFinanciere15Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteFinanciere2_5Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteCommercialeDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteCommerciale20Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteCommercialeAutre");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6NonImposableSuisse");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6NonImposableCanton");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteFinanciereHoldingExempte");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteFinanciereDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteFinanciere15Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteFinanciere2_5Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteCommercialeDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteCommerciale20Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteCommercialeAutre");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7NonImposableSuisse");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7NonImposableCanton");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteFinanciereHoldingExempte");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteFinanciereDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteFinanciere15Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteFinanciere2_5Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteCommercialeDroitCommun");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteCommerciale20Pct");
        annexeMPertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteCommercialeAutre");
        String annexeM101 = "AnnexeM.Page2.TransfertCategorie.BeneficeNetTotalCantonTotalImposableCanton";
        Long champ101 = null;
        ModelItemDTO item101 = (ModelItemDTO)this.getOldDataModel().get("AnnexeM.Page2.TransfertCategorie.BeneficeNetTotalCantonTotalImposableCanton");
        if (item101 != null) {
            Object champ101Obj = item101.getValue();
            if (champ101Obj instanceof Long) {
                champ101 = (Long)champ101Obj;
            }
            if (champ101 != null && champ101 > 0L) {
                for (Object e : annexeMPertesFiscales) {
                    String key = (String)e;
                    ModelItemDTO item = (ModelItemDTO)this.getNewDataModel().get(key);
                    if (item == null || item.getValue() == null) continue;
                    item = item.clone(null);
                    super.storeInNewModel(key, item);
                }
            }
        }
    }

    private void traitePertesFiscalesSAICC() throws ImportException {
        String resultatFiscal = "Declaration.Form2.ResultatFiscalICC";
        String exerciceMoins1 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus1ICC";
        String exerciceMoins2 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus2ICC";
        String exerciceMoins3 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus3ICC";
        String exerciceMoins4 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus4ICC";
        String exerciceMoins5 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus5ICC";
        String exerciceMoins6 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus6ICC";
        String exerciceMoins7 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus7ICC";
        this.setPertesFiscales("Declaration.Form2.ResultatFiscalICC", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus1ICC", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus2ICC", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus3ICC", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus4ICC", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus5ICC", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus6ICC", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus7ICC");
    }

    private void traitePertesFiscalesSAIFD() throws ImportException {
        String resultatFiscal = "Declaration.Form2.ResultatFiscalIFD";
        String exerciceMoins1 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus1IFD";
        String exerciceMoins2 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus2IFD";
        String exerciceMoins3 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus3IFD";
        String exerciceMoins4 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus4IFD";
        String exerciceMoins5 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus5IFD";
        String exerciceMoins6 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus6IFD";
        String exerciceMoins7 = "Declaration.Form2.ExerciceCommercialSteuerjahrMinus7IFD";
        this.setPertesFiscales("Declaration.Form2.ResultatFiscalIFD", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus1IFD", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus2IFD", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus3IFD", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus4IFD", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus5IFD", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus6IFD", "Declaration.Form2.ExerciceCommercialSteuerjahrMinus7IFD");
    }

    private void traitePertesFiscalesAFICC() throws ImportException {
        String resultatFiscal = "Declaration_af.Form2_af.ResultatFiscal.ResultatFiscalICC";
        String exerciceMoins1 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsUnICC";
        String exerciceMoins2 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsDeuxICC";
        String exerciceMoins3 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsTroisICC";
        String exerciceMoins4 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsQuatreICC";
        String exerciceMoins5 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsCinqICC";
        String exerciceMoins6 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsSixICC";
        String exerciceMoins7 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsSeptICC";
        this.setPertesFiscales("Declaration_af.Form2_af.ResultatFiscal.ResultatFiscalICC", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsUnICC", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsDeuxICC", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsTroisICC", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsQuatreICC", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsCinqICC", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsSixICC", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsSeptICC");
    }

    private void traitePertesFiscalesAFIFD() throws ImportException {
        String resultatFiscal = "Declaration_af.Form2_af.ResultatFiscal.ResultatFiscalIFD";
        String exerciceMoins1 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsUnIFD";
        String exerciceMoins2 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsDeuxIFD";
        String exerciceMoins3 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsTroisIFD";
        String exerciceMoins4 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsQuatreIFD";
        String exerciceMoins5 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsCinqIFD";
        String exerciceMoins6 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsSixIFD";
        String exerciceMoins7 = "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsSeptIFD";
        this.setPertesFiscales("Declaration_af.Form2_af.ResultatFiscal.ResultatFiscalIFD", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsUnIFD", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsDeuxIFD", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsTroisIFD", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsQuatreIFD", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsCinqIFD", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsSixIFD", "Declaration_af.Form2_af.ResultatFiscal.ExerciceNMoinsSeptIFD");
    }

    private void setPertesFiscales(String resultatFiscal, String m1, String m2, String m3, String m4, String m5, String m6, String m7) throws ImportException {
        ModelItemDTO miResultatFiscal = (ModelItemDTO)this.getOldDataModel().get(resultatFiscal);
        ModelItemDTO miMoins1 = (ModelItemDTO)this.getNewDataModel().get(m1);
        ModelItemDTO miMoins2 = (ModelItemDTO)this.getNewDataModel().get(m2);
        ModelItemDTO miMoins3 = (ModelItemDTO)this.getNewDataModel().get(m3);
        ModelItemDTO miMoins4 = (ModelItemDTO)this.getNewDataModel().get(m4);
        ModelItemDTO miMoins5 = (ModelItemDTO)this.getNewDataModel().get(m5);
        ModelItemDTO miMoins6 = (ModelItemDTO)this.getNewDataModel().get(m6);
        ModelItemDTO miMoins7 = (ModelItemDTO)this.getNewDataModel().get(m7);
        long lResultatFiscal = 0L;
        String[] mxArray = new String[]{m1, m2, m3, m4, m5, m6, m7};
        if (miResultatFiscal != null && miResultatFiscal.getValue() != null) {
            Object resultatFiscalObj = miResultatFiscal.getValue();
            if (resultatFiscalObj instanceof Long) {
                lResultatFiscal = (Long)resultatFiscalObj;
            }
            if (lResultatFiscal > 0L) {
                long lPerteMoins1 = this.getLPerteMoinsX(miMoins1, m1);
                long lPerteMoins2 = this.getLPerteMoinsX(miMoins2, m2);
                long lPerteMoins3 = this.getLPerteMoinsX(miMoins3, m3);
                long lPerteMoins4 = this.getLPerteMoinsX(miMoins4, m4);
                long lPerteMoins5 = this.getLPerteMoinsX(miMoins5, m5);
                long lPerteMoins6 = this.getLPerteMoinsX(miMoins6, m6);
                long lPerteMoins7 = this.getLPerteMoinsX(miMoins7, m7);
                long solde = lResultatFiscal;
                if (solde > 0L) {
                    this.reporterPerte(m1, m2, m3, m4, m5, m6, m7, miMoins1, miMoins2, miMoins3, miMoins4, miMoins5, miMoins6, miMoins7, lPerteMoins1, lPerteMoins2, lPerteMoins3, lPerteMoins4, lPerteMoins5, lPerteMoins6, lPerteMoins7, solde);
                    this.shift1Year(mxArray, 0L);
                }
            } else {
                this.shift1Year(mxArray, lResultatFiscal * -1L);
            }
        }
    }

    private Long getLPerteMoinsX(ModelItemDTO miMoinsX, String mx) throws ImportException {
        long perte = 0L;
        if (miMoinsX != null && miMoinsX.getValue() != null) {
            Object perteMoinsXObj = miMoinsX.getValue();
            if (perteMoinsXObj instanceof Long) {
                perte = (Long)perteMoinsXObj;
            }
        } else {
            super.storeInNewModel(mx, new ModelItemDTO((Object)0));
        }
        return perte;
    }

    private void reporterPerte(String m1, String m2, String m3, String m4, String m5, String m6, String m7, ModelItemDTO miMoins1, ModelItemDTO miMoins2, ModelItemDTO miMoins3, ModelItemDTO miMoins4, ModelItemDTO miMoins5, ModelItemDTO miMoins6, ModelItemDTO miMoins7, long lPerteMoins1, long lPerteMoins2, long lPerteMoins3, long lPerteMoins4, long lPerteMoins5, long lPerteMoins6, long lPerteMoins7, long solde) throws ImportException {
        if ((solde -= lPerteMoins7) >= 0L) {
            if (miMoins7 != null) {
                miMoins7 = miMoins7.clone(null);
                super.storeInNewModel(m7, miMoins7);
            }
            if ((solde -= lPerteMoins6) >= 0L) {
                if (miMoins6 != null) {
                    miMoins6 = miMoins6.clone(null);
                    super.storeInNewModel(m6, miMoins6);
                }
                if ((solde -= lPerteMoins5) >= 0L) {
                    if (miMoins5 != null) {
                        miMoins5 = miMoins5.clone(null);
                        super.storeInNewModel(m5, miMoins5);
                    }
                    if ((solde -= lPerteMoins4) >= 0L) {
                        if (miMoins4 != null) {
                            miMoins4 = miMoins4.clone(null);
                            super.storeInNewModel(m4, miMoins4);
                        }
                        if ((solde -= lPerteMoins3) >= 0L) {
                            if (miMoins3 != null) {
                                miMoins3 = miMoins3.clone(null);
                                super.storeInNewModel(m3, miMoins3);
                            }
                            if ((solde -= lPerteMoins2) >= 0L) {
                                if (miMoins2 != null) {
                                    miMoins2 = miMoins2.clone(null);
                                    super.storeInNewModel(m2, miMoins2);
                                }
                                if ((solde -= lPerteMoins1) >= 0L) {
                                    if (miMoins1 != null) {
                                        miMoins1 = miMoins1.clone(null);
                                        super.storeInNewModel(m1, miMoins1);
                                    }
                                } else if (miMoins1 != null) {
                                    miMoins1 = miMoins1.clone((Object)(solde * -1L));
                                    super.storeInNewModel(m1, miMoins1);
                                }
                            } else if (miMoins2 != null) {
                                miMoins2 = miMoins2.clone((Object)(solde * -1L));
                                super.storeInNewModel(m2, miMoins2);
                            }
                        } else if (miMoins3 != null) {
                            miMoins3 = miMoins3.clone((Object)(solde * -1L));
                            super.storeInNewModel(m3, miMoins3);
                        }
                    } else if (miMoins4 != null) {
                        miMoins4 = miMoins4.clone((Object)(solde * -1L));
                        super.storeInNewModel(m4, miMoins4);
                    }
                } else if (miMoins5 != null) {
                    miMoins5 = miMoins5.clone((Object)(solde * -1L));
                    super.storeInNewModel(m5, miMoins5);
                }
            } else if (miMoins6 != null) {
                miMoins6 = miMoins6.clone((Object)(solde * -1L));
                super.storeInNewModel(m6, miMoins6);
            }
        } else if (miMoins7 != null) {
            miMoins7 = miMoins7.clone((Object)(solde * -1L));
            super.storeInNewModel(m7, miMoins7);
        }
    }

    private void shift1Year(String[] mTable, long valueM1) throws ImportException {
        for (int i = mTable.length - 1; i > 0; --i) {
            String mx = mTable[i];
            String mxMinus1 = mTable[i - 1];
            ModelItemDTO miMoins1X = (ModelItemDTO)this.getNewDataModel().get(mxMinus1);
            if (miMoins1X == null || miMoins1X.getValue() == null) {
                miMoins1X = new ModelItemDTO((Object)0);
            }
            super.storeInNewModel(mx, miMoins1X);
        }
        if (mTable.length > 0) {
            String m1 = mTable[0];
            ModelItemDTO mi1 = (ModelItemDTO)this.getNewDataModel().get(m1);
            if (mi1 != null) {
                mi1 = mi1.clone((Object)valueM1);
                super.storeInNewModel(m1, mi1);
            }
        }
    }

    private Date addYear(Date date, int nbreAnnee) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(1, nbreAnnee);
        return calendar.getTime();
    }

    private Date addDay(Date dateFinExercicePrecedent, int nbreJour) {
        GregorianCalendar calendarFinExercicePrecedent = new GregorianCalendar();
        calendarFinExercicePrecedent.setTime(dateFinExercicePrecedent);
        GregorianCalendar calFinPeriodePrecedente = new GregorianCalendar();
        calFinPeriodePrecedente.set(ApplicationConfig.getInstance().getJahr(), 11, 31);
        calendarFinExercicePrecedent.setTime(dateFinExercicePrecedent);
        ((Calendar)calendarFinExercicePrecedent).add(6, nbreJour);
        return calendarFinExercicePrecedent.getTime();
    }

    static {
        HashMap<String, String> champscalcules = new HashMap<String, String>();
        champscalcules.put("Declaration.Form1.DateFin", "Declaration.Form1.DateFin");
        DECLA_PAGE1_MAP = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("Declaration_af.Form1_af.DateFin", "Declaration_af.Form1_af.DateFin");
        DECLA_PAGE1_AF_MAP = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeF.ValeurFiscale.ImmLoueGeneve.TauxCapitalisation", "AnnexeF.ValeurFiscale.ImmLoueGeneve.TauxCapitalisation");
        champscalcules.put("AnnexeF.ValeurFiscale.ImmOccupeGeneve.TauxCapitalisation", "AnnexeF.ValeurFiscale.ImmOccupeGeneve.TauxCapitalisation");
        ANNEXE_F_MAP = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeF_af.ValeurFiscale.ImmLoueGeneve.TauxCapitalisation", "AnnexeF_af.ValeurFiscale.ImmLoueGeneve.TauxCapitalisation");
        champscalcules.put("AnnexeF_af.ValeurFiscale.ImmOccupeGeneve.TauxCapitalisation", "AnnexeF_af.ValeurFiscale.ImmOccupeGeneve.TauxCapitalisation");
        ANNEXE_F_AF_MAP = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutA", "AnnexeJ.AJ.Page1.ForPrincipal.DebutA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutB", "AnnexeJ.AJ.Page1.ForPrincipal.DebutB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutC", "AnnexeJ.AJ.Page1.ForPrincipal.DebutC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutD", "AnnexeJ.AJ.Page1.ForPrincipal.DebutD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutE", "AnnexeJ.AJ.Page1.ForPrincipal.DebutE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinA", "AnnexeJ.AJ.Page1.ForPrincipal.FinA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinB", "AnnexeJ.AJ.Page1.ForPrincipal.FinB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinC", "AnnexeJ.AJ.Page1.ForPrincipal.FinC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinD", "AnnexeJ.AJ.Page1.ForPrincipal.FinD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinE", "AnnexeJ.AJ.Page1.ForPrincipal.FinE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutA", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutB", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutC", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutD", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutE", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinA", "AnnexeJ.AJ.Page1.ForsSecondaires.FinA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinB", "AnnexeJ.AJ.Page1.ForsSecondaires.FinB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinC", "AnnexeJ.AJ.Page1.ForsSecondaires.FinC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinD", "AnnexeJ.AJ.Page1.ForsSecondaires.FinD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinE", "AnnexeJ.AJ.Page1.ForsSecondaires.FinE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutA", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutB", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutC", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutD", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutE", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinA", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinB", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinC", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinD", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinE", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinE");
        ANNEXE_J_MAP = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutA", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutB", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutC", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutD", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutE", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinA", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinB", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinC", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinD", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinE", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutA", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutB", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutC", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutD", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutE", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinA", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinB", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinC", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinD", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinE", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutA", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutB", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutC", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutD", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutE", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinA", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinB", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinC", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinD", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinE", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinE");
        ANNEXE_J_AF_MAP = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutA", "AnnexeK.AK.Page1.ForPrincipal.DebutA");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutB", "AnnexeK.AK.Page1.ForPrincipal.DebutB");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutC", "AnnexeK.AK.Page1.ForPrincipal.DebutC");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutD", "AnnexeK.AK.Page1.ForPrincipal.DebutD");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutE", "AnnexeK.AK.Page1.ForPrincipal.DebutE");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinA", "AnnexeK.AK.Page1.ForPrincipal.FinA");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinB", "AnnexeK.AK.Page1.ForPrincipal.FinB");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinC", "AnnexeK.AK.Page1.ForPrincipal.FinC");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinD", "AnnexeK.AK.Page1.ForPrincipal.FinD");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinE", "AnnexeK.AK.Page1.ForPrincipal.FinE");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutA", "AnnexeK.AK.Page1.ForsSecondaires.DebutA");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutB", "AnnexeK.AK.Page1.ForsSecondaires.DebutB");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutC", "AnnexeK.AK.Page1.ForsSecondaires.DebutC");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutD", "AnnexeK.AK.Page1.ForsSecondaires.DebutD");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutE", "AnnexeK.AK.Page1.ForsSecondaires.DebutE");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinA", "AnnexeK.AK.Page1.ForsSecondaires.FinA");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinB", "AnnexeK.AK.Page1.ForsSecondaires.FinB");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinC", "AnnexeK.AK.Page1.ForsSecondaires.FinC");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinD", "AnnexeK.AK.Page1.ForsSecondaires.FinD");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinE", "AnnexeK.AK.Page1.ForsSecondaires.FinE");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutA", "AnnexeK.AK.Page1.ForsSpeciaux.DebutA");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutB", "AnnexeK.AK.Page1.ForsSpeciaux.DebutB");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutC", "AnnexeK.AK.Page1.ForsSpeciaux.DebutC");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutD", "AnnexeK.AK.Page1.ForsSpeciaux.DebutD");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutE", "AnnexeK.AK.Page1.ForsSpeciaux.DebutE");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinA", "AnnexeK.AK.Page1.ForsSpeciaux.FinA");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinB", "AnnexeK.AK.Page1.ForsSpeciaux.FinB");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinD", "AnnexeK.AK.Page1.ForsSpeciaux.FinD");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinE", "AnnexeK.AK.Page1.ForsSpeciaux.FinE");
        ANNEXE_K_MAP = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutA", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutB", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutC", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutD", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutE", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinA", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinB", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinC", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinD", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinE", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutA", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutB", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutC", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutD", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutE", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinA", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinB", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinC", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinD", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinE", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutA", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutB", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutC", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutD", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutE", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinA", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinB", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinC", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinD", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinE", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinE");
        ANNEXE_K_AF_MAP = Collections.unmodifiableMap(champscalcules);
    }
}

