/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.util;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxmeGeFilename
extends TaxFileConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TaxmeGeFilename.class);
    private static final String WARN_TAX_YEAR_CONVERSION_FAILED = "tax year conversion failed";
    private static final String TAX_YEAR_KEY = "Declaration.PeriodeTaxation";
    private static final String TAX_YEAR_KEY_AF = "Declaration_af.PeriodeTaxation";
    private static final String TAX_YEAR_KEY_PROVISON_SA = "ProvisionSA.PeriodeTaxation";
    private static final String TAX_YEAR_KEY_PROVISON_AF = "ProvisionAF.PeriodeTaxation";
    private static final String SELECTION_SA = "Selection.SA";

    public boolean checkVersion(Map<String, ModelItemDTO> dataModel) {
        Long currentYear = ApplicationConfig.getInstance().getJahr();
        Long taxYear = null;
        ModelItemDTO taxYearItem = dataModel.get(TAX_YEAR_KEY);
        ModelItemDTO taxYearItemAF = dataModel.get(TAX_YEAR_KEY_AF);
        ModelItemDTO taxYearItemProvisionSA = dataModel.get(TAX_YEAR_KEY_PROVISON_SA);
        ModelItemDTO taxYearItemProvisionAF = dataModel.get(TAX_YEAR_KEY_PROVISON_AF);
        if (taxYearItem != null) {
            taxYear = this.extractTaxYear(taxYearItem);
        } else if (taxYearItemAF != null) {
            taxYear = this.extractTaxYear(taxYearItemAF);
        } else if (taxYearItemProvisionSA != null) {
            taxYear = this.extractTaxYear(taxYearItemProvisionSA);
        } else if (taxYearItemProvisionAF != null) {
            taxYear = this.extractTaxYear(taxYearItemProvisionAF);
        }
        if (taxYear == null) {
            ModelItemDTO selectionSAItem = dataModel.get(SELECTION_SA);
            String taxYearDMK = selectionSAItem != null && Boolean.TRUE.equals(selectionSAItem.getValue()) ? TAX_YEAR_KEY : TAX_YEAR_KEY_AF;
            ModelItemDTO item = new ModelItemDTO((Object)currentYear);
            item.setTouched();
            TaxmeController.getInstance().getTmoCdSession().update(Collections.singletonMap(taxYearDMK, item), false);
            LOG.error("Failed to retrieve current tax year in opened tax file, assuming default: " + currentYear);
            return true;
        }
        return currentYear.equals(taxYear);
    }

    private Long extractTaxYear(ModelItemDTO taxYearItem) {
        Long taxYear = null;
        Object value = taxYearItem.getValue();
        if (value != null) {
            if (value instanceof Long) {
                taxYear = (Long)value;
            } else {
                try {
                    taxYear = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    LOG.warn(WARN_TAX_YEAR_CONVERSION_FAILED, (Throwable)e);
                    taxYear = null;
                }
            }
        }
        return taxYear;
    }
}

