/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class GeResources {
    private GeResources() {
    }

    public static void init() {
        for (Font font : Font.values()) {
            font.register();
        }
        for (Enum enum_ : Color.values()) {
            ((Color)enum_).register();
        }
        for (Enum enum_ : Icon.values()) {
            ((Icon)enum_).register();
        }
        GuiUtil.registerIcon((String)"icon.release", (String)"release.gif");
        GuiUtil.registerIcon((String)"icon.release.disabled", (String)"release-disabled.gif");
        GuiUtil.registerIcon((String)"icon.document", (String)"dossier.gif");
        GuiUtil.registerIcon((String)"icon.document.transparent", (String)"dossier-disabled.gif");
        GuiUtil.registerIcon((String)"icon.state.error", (String)"icon_red.gif");
        GuiUtil.registerIcon((String)"icon.state.error", (String)"icon_red.gif");
        GuiUtil.registerIcon((String)"icon.state.error.transparent", (String)"icon_red_disabled.gif");
        GuiUtil.registerIcon((String)"icon.state.ok", (String)"icon_green.gif");
        GuiUtil.registerIcon((String)"icon.state.ok.transparent", (String)"icon_green_disabled.gif");
        GuiUtil.registerIcon((String)"icon.state.missingvalue", (String)"icon_white.gif");
        GuiUtil.registerIcon((String)"icon.state.missingvalue.transparent", (String)"icon_white_disabled.gif");
        GuiUtil.registerIcon((String)"icon.state.warning", (String)"icon_yellow.gif");
        GuiUtil.registerIcon((String)"icon.state.warning.transparent", (String)"icon_yellow_disabled.gif");
    }

    public static void setBoldFont(@Nonnull Control control) {
        Objects.requireNonNull(control, "Target control cannot be null.");
        FontRegistry registry = GuiUtil.getFontRegistry();
        String symbolicName = GeResources.addFontToRegistryIfMissing(registry, control);
        control.setFont(registry.getBold(symbolicName));
    }

    public static void setItalicFont(@Nonnull Control control) {
        Objects.requireNonNull(control, "Target control cannot be null.");
        FontRegistry registry = GuiUtil.getFontRegistry();
        String symbolicName = GeResources.addFontToRegistryIfMissing(registry, control);
        control.setFont(registry.getItalic(symbolicName));
    }

    private static String addFontToRegistryIfMissing(FontRegistry registry, Control control) {
        assert (control != null);
        String symbolicName = control.getClass().getName();
        if (!registry.hasValueFor(symbolicName)) {
            registry.put(symbolicName, control.getFont().getFontData());
        }
        return symbolicName;
    }

    public static enum Font {
        DIALOG_TITLE(12, 1),
        CATEGORY_HEADER(11, 1),
        DOCUMENT_LABEL(9, 0),
        EMPTY_TABLE_LABEL(9, 1),
        SMALL(8, 0);

        private final int size;
        private final int style;

        private Font(int size, int style) {
            this.size = size;
            this.style = style;
        }

        public org.eclipse.swt.graphics.Font get() {
            return GuiUtil.getFontRegistry().get(this.name());
        }

        private void register() {
            GuiUtil.registerFont((String)this.name(), (int)this.size, (int)this.style);
        }
    }

    public static enum Color {
        ODD_ROW(255, 255, 255),
        EVEN_ROW(255, 255, 255),
        GRAY_BORDER(200, 200, 200),
        WHITE(255, 255, 255),
        HL(255, 0, 0),
        REQUIRED_FIELD(255, 213, 224),
        RED(255, 0, 0);

        private final int red;
        private final int green;
        private final int blue;

        private Color(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public org.eclipse.swt.graphics.Color get() {
            return GuiUtil.getColorRegistry().get(this.name());
        }

        private void register() {
            GuiUtil.registerColor((String)this.name(), (int)this.red, (int)this.green, (int)this.blue);
        }
    }

    public static enum Icon {
        EDEMARCHES("edemarche.png"),
        DOC_PRINT("doc-print.gif"),
        DOC_ADD("doc-add.png"),
        DOC_EDIT("doc-edit.png"),
        DOC_PREVIEW("doc-preview.png"),
        DOC_DELETE("doc-delete.png");

        private final String filename;

        private Icon(String filename) {
            this.filename = filename;
        }

        public Image get() {
            return GuiUtil.getImageRegistry().get(this.name());
        }

        private void register() {
            GuiUtil.registerIcon((String)this.name(), (String)this.filename);
        }
    }
}

