/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.util;

import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtilCD;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.presentation.common.print.PrintUtil;
import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.ge.pm.presentation.cd.util.GeCdApplicationConfig;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class GeEnvoiElectroniquePrintJob
implements IRunnableWithProgress {
    private static final String BARCODE_FORM = "Barcode";
    private static final String BARCODE_AF_FORM = "Barcode_af";
    private PrintRequest printRequest;
    private ExpertDisplayInfoDTO background;
    private final long timestamp;
    private final OutputStream output;

    public GeEnvoiElectroniquePrintJob(long timestamp, OutputStream output) {
        if (output == null) {
            throw new NullPointerException("output cannot be null");
        }
        this.timestamp = timestamp;
        this.output = output;
    }

    private static void addItemsRecursive(ExpertDisplayInfoDTO.NavigationDTO navigationDTO, PrintRequest printRequest) {
        if (navigationDTO.getSubItems() != null) {
            for (ExpertDisplayInfoDTO.NavigationDTO childDTO : navigationDTO.getSubItems()) {
                GeEnvoiElectroniquePrintJob.addItemsRecursive(childDTO, printRequest);
            }
        } else {
            printRequest.withExpertKeys(new String[]{navigationDTO.getAccessKey()});
        }
    }

    private void init() {
        this.printRequest = PrintUtilCD.newPrintRequest();
        TaxmeController ctrl = TaxmeController.getInstance();
        List navigationsDTO = ctrl.getTmoCdSession().getExpertNavigationItems();
        for (ExpertDisplayInfoDTO.NavigationDTO navigationDTO : navigationsDTO) {
            String formName;
            if ((navigationDTO.getState() == 1 || navigationDTO.getState() == 2) && navigationDTO.getPrintState() != 12 && !(formName = navigationDTO.getFormName()).equals(BARCODE_FORM) && !formName.equals(BARCODE_AF_FORM)) continue;
        }
        this.background = ctrl.getExpertDisplayInfoDTO("wizardprintbackground", 2);
    }

    public void run(final IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        this.init();
        if (mon != null) {
            mon.beginTask(Messages.translate((String)"label.dialog.envoi.task.generationarchive.declaration", (Object[])new Object[0]), this.printRequest.getFormKeys().size());
        }
        TaxmeController ctrl = TaxmeController.getInstance();
        ProgressListener progressListener = mon != null ? new ProgressListener(){

            public void formRendered(int form) {
                mon.worked(1);
            }
        } : null;
        try {
            FormRendererConfiguration configuration = GeCdApplicationConfig.newPrintConfiguration().withWizardBackground(this.background).withTimestamp(Long.valueOf(this.timestamp));
            this.printRequest.withConfiguration(configuration).withProgressListener(progressListener);
            PrintUtil.print((DvbTaxSession)ctrl.getTmoCdSession(), (PrintRequest)this.printRequest, (OutputStream)this.output, (boolean)false);
        }
        catch (FormRendererException e) {
            throw new InvocationTargetException(e, "Error printing forms");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.output);
        }
    }
}

