/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.upload;

import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pm.presentation.cd.upload.CryptoSession;
import ch.dvbern.tax.ge.pm.presentation.cd.util.CodeDeclarationIdentificationCodeCalculator;
import ch.dvbern.tax.ge.pm.transfer.utils.BarcodeConfiguration;
import ch.dvbern.tax.ge.pm.utils.InternalFailureException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

class UploadRequest {
    private final CryptoSession cryptoSession;
    private final long timestamp = System.currentTimeMillis();
    private String companyName;
    private String codeDeclaration;
    private String taxPayerNumber;
    private BarcodeConfiguration barcodeConfiguration;

    UploadRequest() {
        try {
            this.cryptoSession = CryptoSession.newInstance();
        }
        catch (GeneralSecurityException e) {
            throw new InternalFailureException("Failed to load cryptographic session.", e);
        }
    }

    static @NonNull UploadRequest build(@NonNull BarcodeConfiguration barcodeConfiguration, @NonNull Map<String, ModelItemDTO> dataModel) {
        Objects.requireNonNull(barcodeConfiguration, "Barcode configuration cannot be null.");
        Objects.requireNonNull(dataModel, "Data model cannot be null.");
        UploadRequest request = new UploadRequest();
        String codeDeclaDmk = "";
        String raisonSocialeDmk = "";
        String noContribDmk = "";
        ModelItemDTO selectionSA = dataModel.get("Selection.SA");
        if (selectionSA != null && selectionSA.getValue() != null && ((Boolean)selectionSA.getValue()).booleanValue()) {
            codeDeclaDmk = "Declaration.Form1.CodeDeclaration";
            raisonSocialeDmk = "Declaration.Form1.RaisonSociale";
            noContribDmk = "Declaration.Form1.NumeroContribuable";
        } else {
            codeDeclaDmk = "Declaration_af.Form1_af.CodeDeclaration";
            raisonSocialeDmk = "Declaration_af.Form1_af.RaisonSociale";
            noContribDmk = "Declaration_af.Form1_af.NumeroContribuable";
        }
        request.companyName = (String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)raisonSocialeDmk);
        request.taxPayerNumber = (String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)noContribDmk);
        request.codeDeclaration = new CodeDeclarationIdentificationCodeCalculator(TaxmeConfig.getString((String)"steuerjahr")).getCodeDeclarationWithControlCode(request.taxPayerNumber, (String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)codeDeclaDmk));
        request.barcodeConfiguration = barcodeConfiguration;
        return request;
    }

    @NonNull String getCompanyName() {
        return this.companyName;
    }

    @NonNull String getCodeDeclaration() {
        return this.codeDeclaration;
    }

    @NonNull String getTaxPayerNumber() {
        return this.taxPayerNumber;
    }

    @NonNull CryptoSession getCryptoSession() {
        return this.cryptoSession;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    @NonNull BarcodeConfiguration getBarcodeConfiguration() {
        return this.barcodeConfiguration;
    }

    public @NonNull String getCodeDeclarationWithoutChecksum() {
        String codeWithoutCHecksum = this.codeDeclaration.replaceAll("[^\\d]", "");
        return codeWithoutCHecksum;
    }
}

